/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.adaboostmh;

import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.multilabel_classification.MultiLabelClassifier;
import edu.neu.ccs.pyramid.regression.Regressor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Vector;

public class AdaBoostMH
implements MultiLabelClassifier,
MultiLabelClassifier.ClassScoreEstimator {
    private static final long serialVersionUID = 2L;
    private List<List<Regressor>> regressors;
    private int numClasses;
    private FeatureList featureList;
    private LabelTranslator labelTranslator;

    public AdaBoostMH(int numClasses) {
        this.numClasses = numClasses;
        this.regressors = new ArrayList<List<Regressor>>(this.numClasses);
        for (int k = 0; k < this.numClasses; ++k) {
            ArrayList regressorsClassK = new ArrayList();
            this.regressors.add(regressorsClassK);
        }
    }

    @Override
    public int getNumClasses() {
        return this.numClasses;
    }

    @Override
    public MultiLabel predict(Vector vector) {
        MultiLabel prediction = new MultiLabel();
        for (int k = 0; k < this.numClasses; ++k) {
            double score = this.predictClassScore(vector, k);
            if (!(score > 0.0)) continue;
            prediction.addLabel(k);
        }
        return prediction;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @Override
    public LabelTranslator getLabelTranslator() {
        return this.labelTranslator;
    }

    @Override
    public double predictClassScore(Vector vector, int k) {
        List<Regressor> regressorsClassK = this.regressors.get(k);
        double score = 0.0;
        for (Regressor regressor : regressorsClassK) {
            score += regressor.predict(vector);
        }
        return score;
    }

    void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }

    void setLabelTranslator(LabelTranslator labelTranslator) {
        this.labelTranslator = labelTranslator;
    }

    void addRegressor(Regressor regressor, int k) {
        this.regressors.get(k).add(regressor);
    }

    public List<Regressor> getRegressors(int k) {
        return this.regressors.get(k);
    }

    double[] calClassScores(Vector vector) {
        int numClasses = this.numClasses;
        double[] scores = new double[numClasses];
        for (int k = 0; k < numClasses; ++k) {
            scores[k] = this.predictClassScore(vector, k);
        }
        return scores;
    }

    public static AdaBoostMH deserialize(String file) throws Exception {
        return AdaBoostMH.deserialize(new File(file));
    }

    /*
     * Exception decompiling
     */
    public static AdaBoostMH deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

