/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public class MLPriorProbClassifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int numClasses;
    private double[] classProbs;

    public MLPriorProbClassifier(int numClasses) {
        this.numClasses = numClasses;
        this.classProbs = new double[numClasses];
    }

    public void fit(MultiLabelClfDataSet dataSet) {
        MultiLabel[] multiLabels;
        if (dataSet.getNumClasses() != this.numClasses) {
            throw new IllegalArgumentException("dataSet.getNumClasses()!=this.numClasses");
        }
        int[] counts = new int[this.numClasses];
        for (MultiLabel multiLabel : multiLabels = dataSet.getMultiLabels()) {
            Iterator<Integer> iterator = multiLabel.getMatchedLabels().iterator();
            while (iterator.hasNext()) {
                int matchedClass;
                int n = matchedClass = iterator.next().intValue();
                counts[n] = counts[n] + 1;
            }
        }
        for (int k = 0; k < this.numClasses; ++k) {
            this.classProbs[k] = (double)counts[k] / (double)dataSet.getNumDataPoints();
        }
    }

    public double[] getClassProbs() {
        return this.classProbs;
    }

    public String toString() {
        return "MLPriorProbClassifier{numClasses=" + this.numClasses + ", classProbs=" + Arrays.toString(this.classProbs) + '}';
    }
}

