/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature_selection;

import edu.neu.ccs.pyramid.util.EmpiricalCDF;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class FusedKolmogorovFilter {
    private int numBins = 100;

    public void setNumBins(int numBins) {
        this.numBins = numBins;
    }

    public double score(Vector vector, int[] labels, int numClasses) {
        List<List<Double>> inputsEachClass = this.generateInputsEachClass(vector, labels, numClasses);
        List<EmpiricalCDF> empiricalCDFs = this.generateCDFs(vector, inputsEachClass);
        return this.maxDistance(empiricalCDFs);
    }

    public List<List<Double>> generateInputsEachClass(Vector vector, int[] labels, int numClasses) {
        Object input = vector.isDense() ? vector : new DenseVector(vector);
        ArrayList<List<Double>> inputsEachClass = new ArrayList<List<Double>>();
        for (int k = 0; k < numClasses; ++k) {
            inputsEachClass.add(new ArrayList());
        }
        for (int i = 0; i < labels.length; ++i) {
            int label = labels[i];
            ((List)inputsEachClass.get(label)).add(input.get(i));
        }
        return inputsEachClass;
    }

    public List<EmpiricalCDF> generateCDFs(Vector vector, List<List<Double>> inputsEachClass) {
        double min = vector.minValue();
        double max = vector.maxValue();
        return inputsEachClass.stream().map(list -> new EmpiricalCDF((List<Double>)list, min, max, this.numBins)).collect(Collectors.toList());
    }

    double maxDistance(List<EmpiricalCDF> empiricalCDFs) {
        int numClasses = empiricalCDFs.size();
        double max = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < numClasses - 1; ++k) {
            for (int j = k + 1; j < numClasses; ++j) {
                double distance = EmpiricalCDF.distance(empiricalCDFs.get(k), empiricalCDFs.get(j));
                if (!(distance > max)) continue;
                max = distance;
            }
        }
        return max;
    }
}

