/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature_selection;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.elasticsearch.ESIndex;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.Ngram;
import edu.neu.ccs.pyramid.feature.SpanNotNgram;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.elasticsearch.index.query.SpanNotQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.index.query.SpanTermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

@JsonSerialize(using=Serializer.class)
public class FeatureDistribution
implements Serializable {
    private static final long serialVersionUID = 3L;
    private Feature feature;
    private long totalCount;
    private long[] occurInEach;
    private long[] labelDistribution;
    private LabelTranslator labelTranslator;

    public FeatureDistribution(Ngram ngram, ESIndex index, String labelField, String[] ids, LabelTranslator labelTranslator, long[] labelDistribution) {
        this.feature = ngram;
        this.labelDistribution = labelDistribution;
        this.labelTranslator = labelTranslator;
        int numClasses = labelTranslator.getNumClasses();
        this.occurInEach = new long[numClasses];
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[i]));
        }
        queryBuilder.inOrder(inOrder);
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{index.getDocumentType()});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)index.getClient().prepareSearch(new String[]{index.getIndexName()}).setSize(0).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)idsFilterBuilder).should((QueryBuilder)queryBuilder)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(labelField)).size(Integer.MAX_VALUE)).execute().actionGet();
        this.totalCount = response.getHits().getTotalHits();
        Terms terms = (Terms)response.getAggregations().get("agg");
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            String extLabel = (String)bucket.getKey();
            long count = bucket.getDocCount();
            int classIndex = labelTranslator.toIntLabel(extLabel);
            this.occurInEach[classIndex] = count;
        }
    }

    public FeatureDistribution(SpanNotNgram ngram, ESIndex index, String labelField, String[] ids, LabelTranslator labelTranslator) {
        this.feature = ngram;
        int numClasses = labelTranslator.getNumClasses();
        this.occurInEach = new long[numClasses];
        Ngram include = ngram.getInclude();
        String field1 = include.getField();
        int slop1 = include.getSlop();
        boolean inOrder1 = include.isInOrder();
        SpanNearQueryBuilder queryBuilder1 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[0]), (int)slop1);
        for (int i = 1; i < include.getTerms().length; ++i) {
            queryBuilder1.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[i]));
        }
        queryBuilder1.inOrder(inOrder1);
        Ngram exclude = ngram.getExclude();
        String field2 = exclude.getField();
        int slop2 = exclude.getSlop();
        boolean inOrder2 = exclude.isInOrder();
        SpanNearQueryBuilder queryBuilder2 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[0]), (int)slop2);
        for (int i = 1; i < exclude.getTerms().length; ++i) {
            queryBuilder2.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[i]));
        }
        queryBuilder2.inOrder(inOrder2);
        int pre = ngram.getPre();
        int post = ngram.getPost();
        SpanNotQueryBuilder spanNotQueryBuilder = new SpanNotQueryBuilder((SpanQueryBuilder)queryBuilder1, (SpanQueryBuilder)queryBuilder2);
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{index.getDocumentType()});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)index.getClient().prepareSearch(new String[]{index.getIndexName()}).setSize(0).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)idsFilterBuilder).should((QueryBuilder)spanNotQueryBuilder)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(labelField)).size(Integer.MAX_VALUE)).execute().actionGet();
        this.totalCount = response.getHits().getTotalHits();
        Terms terms = (Terms)response.getAggregations().get("agg");
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            String extLabel = (String)bucket.getKey();
            long count = bucket.getDocCount();
            int classIndex = labelTranslator.toIntLabel(extLabel);
            this.occurInEach[classIndex] = count;
        }
    }

    public void setClassCount(int classIndex, long count) {
        this.occurInEach[classIndex] = count;
    }

    public long getClassCount(int classIndex) {
        return this.occurInEach[classIndex];
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public long[] getOccurInEach() {
        return this.occurInEach;
    }

    public void setOccurInEach(long[] occurInEach) {
        this.occurInEach = occurInEach;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NgramClassDistribution{");
        sb.append("feature=").append(this.feature);
        sb.append(", totalCount=").append(this.totalCount);
        sb.append(", occurInEach=").append(Arrays.toString(this.occurInEach));
        sb.append('}');
        return sb.toString();
    }

    public List<String> pretty() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.occurInEach.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.labelTranslator.toExtLabel(i)).append(":");
            sb.append(this.occurInEach[i]).append("/").append(this.labelDistribution[i]);
            list.add(sb.toString());
        }
        return list;
    }

    public static class Serializer
    extends JsonSerializer<FeatureDistribution> {
        public void serialize(FeatureDistribution distribution, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("feature", (Object)distribution.feature);
            jsonGenerator.writeNumberField("totalCount", distribution.totalCount);
            jsonGenerator.writeObjectField("occurrence", distribution.pretty());
            jsonGenerator.writeEndObject();
        }
    }
}

