/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature_extraction;

import edu.neu.ccs.pyramid.feature_extraction.KaryTree;
import edu.neu.ccs.pyramid.feature_extraction.Node;
import java.util.List;

public class NgramTemplate {
    private int n;
    private int slop;
    private String field;
    private List<List<Integer>> positionTemplate;

    public NgramTemplate(String field, int n, int slop) {
        this.field = field;
        this.n = n;
        this.slop = slop;
        KaryTree<Integer> tree = new KaryTree<Integer>();
        tree.root.setValue(0);
        tree.root.setSlop(0);
        tree.root.setLength(1);
        NgramTemplate.grow(tree, tree.root, n, slop);
        this.positionTemplate = tree.getAllPaths();
    }

    private static void grow(KaryTree<Integer> tree, Node<Integer> node, int n, int slop) {
        int currentN = node.getLength();
        int currentSlop = node.getSlop();
        if (currentN == n) {
            tree.leaves.add(node);
            return;
        }
        for (int i = 0; i <= slop - currentSlop; ++i) {
            Node<Integer> child = new Node<Integer>();
            child.setValue(node.getValue() + i + 1);
            child.setLength(currentN + 1);
            child.setSlop(currentSlop + i);
            node.addChild(child);
            NgramTemplate.grow(tree, child, n, slop);
        }
    }

    public int getN() {
        return this.n;
    }

    public int getSlop() {
        return this.slop;
    }

    public String getField() {
        return this.field;
    }

    public List<List<Integer>> getPositionTemplate() {
        return this.positionTemplate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NgramTemplate{");
        sb.append("n=").append(this.n);
        sb.append(", slop=").append(this.slop);
        sb.append(", positionTemplate=").append(this.positionTemplate);
        sb.append('}');
        return sb.toString();
    }
}

