/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature_extraction;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import edu.neu.ccs.pyramid.elasticsearch.ESIndex;
import edu.neu.ccs.pyramid.feature.Ngram;
import edu.neu.ccs.pyramid.feature_extraction.NgramTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NgramEnumerator {
    public static Multiset<Ngram> gatherNgram(ESIndex index, String[] ids, NgramTemplate template) {
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create();
        String field = template.getField();
        ((Stream)Arrays.stream(ids).parallel()).forEach(arg_0 -> NgramEnumerator.lambda$gatherNgram$0(index, field, (Multiset)multiset, template, arg_0));
        return multiset;
    }

    public static Multiset<Ngram> gatherNgram(ESIndex index, String[] ids, NgramTemplate template, int minDF) {
        ConcurrentHashMultiset multiset = ConcurrentHashMultiset.create();
        String field = template.getField();
        ((Stream)Arrays.stream(ids).parallel()).forEach(arg_0 -> NgramEnumerator.lambda$gatherNgram$1(index, field, (Multiset)multiset, template, arg_0));
        ConcurrentHashMultiset filtered = ConcurrentHashMultiset.create();
        for (Multiset.Entry entry : multiset.entrySet()) {
            Ngram ngram = (Ngram)entry.getElement();
            int count = entry.getCount();
            if (count < minDF) continue;
            filtered.add((Object)ngram, count);
        }
        return filtered;
    }

    public static List<String> gatherNgrams(ESIndex index, String field, String[] ids, int n, int minDf) throws Exception {
        ConcurrentHashMap counts = new ConcurrentHashMap();
        ((Stream)Arrays.stream(ids).parallel()).forEach(id -> {
            Map<Integer, String> termVector = index.getTermVectorFromIndex(field, (String)id);
            Map<String, Integer> localCount = NgramEnumerator.getNgramCounts(termVector, n);
            for (Map.Entry<String, Integer> entry : localCount.entrySet()) {
                String ngram = entry.getKey();
                int oldCount = counts.getOrDefault(ngram, 0);
                int newCount = oldCount + 1;
                counts.put(ngram, newCount);
            }
        });
        return counts.entrySet().parallelStream().filter(entry -> (Integer)entry.getValue() >= minDf).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Map<String, Integer> getNgramCounts(Map<Integer, String> termVector, int n) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Comparator<Map.Entry> comparator = Comparator.comparing(Map.Entry::getKey);
        List entryList = termVector.entrySet().stream().sorted(comparator).collect(Collectors.toList());
        if (entryList.size() == 0) {
            return counts;
        }
        ArrayList<String> sequence = new ArrayList<String>();
        int last = -2;
        for (Map.Entry entry : entryList) {
            int index = (Integer)entry.getKey();
            String term = (String)entry.getValue();
            if (index != last + 1) {
                NgramEnumerator.updateNgramCounts(sequence, n, counts);
                sequence = new ArrayList();
            }
            last = index;
            sequence.add(term);
        }
        NgramEnumerator.updateNgramCounts(sequence, n, counts);
        return counts;
    }

    static void updateNgramCounts(List<String> sequence, int n, Map<String, Integer> map) {
        if (n > sequence.size()) {
            return;
        }
        for (int start = 0; start <= sequence.size() - n; ++start) {
            String ngram = NgramEnumerator.toNgram(sequence, start, start + n - 1);
            int oldCount = map.getOrDefault(ngram, 0);
            int newCount = oldCount + 1;
            map.put(ngram, newCount);
        }
    }

    static String toNgram(List<String> sequence, int start, int end) {
        String str = "";
        for (int i = start; i < end; ++i) {
            str = str.concat(sequence.get(i));
            str = str.concat(" ");
        }
        str = str.concat(sequence.get(end));
        return str;
    }

    private static void add(List<String> source, Multiset<Ngram> multiset, String field, int slop, List<Integer> template) {
        ConcurrentHashMultiset multiSetForDoc = ConcurrentHashMultiset.create();
        for (int i = 0; i < source.size(); ++i) {
            if (i + template.get(template.size() - 1) >= source.size()) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int j : template) {
                list.add(source.get(i + j));
            }
            Ngram ngram = new Ngram();
            ngram.setNgram(Ngram.toNgramString(list));
            ngram.setSlop(slop);
            ngram.setField(field);
            ngram.setInOrder(true);
            multiSetForDoc.setCount((Object)ngram, 1);
        }
        multiset.addAll((Collection)multiSetForDoc);
    }

    public static void add(List<String> source, Multiset<Ngram> multiset, NgramTemplate template) {
        for (List<Integer> list : template.getPositionTemplate()) {
            NgramEnumerator.add(source, multiset, template.getField(), template.getSlop(), list);
        }
    }

    public static void add(Map<Integer, String> termVector, Multiset<Ngram> multiset, NgramTemplate template) {
        Comparator<Map.Entry> comparator = Comparator.comparing(Map.Entry::getKey);
        List<String> source = termVector.entrySet().stream().sorted(comparator).map(Map.Entry::getValue).collect(Collectors.toList());
        NgramEnumerator.add(source, multiset, template);
    }

    private static /* synthetic */ void lambda$gatherNgram$1(ESIndex index, String field, Multiset multiset, NgramTemplate template, String id) {
        Map<Integer, String> termVector = index.getTermVectorFromIndex(field, id);
        NgramEnumerator.add(termVector, (Multiset<Ngram>)multiset, template);
    }

    private static /* synthetic */ void lambda$gatherNgram$0(ESIndex index, String field, Multiset multiset, NgramTemplate template, String id) {
        Map<Integer, String> termVector = index.getTermVectorFromIndex(field, id);
        NgramEnumerator.add(termVector, (Multiset<Ngram>)multiset, template);
    }
}

