/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.Ngram;
import java.util.ArrayList;
import java.util.List;

public class SpanNotNgram
extends Feature {
    private Ngram include;
    private Ngram exclude;
    private int pre;
    private int post;

    public Ngram getInclude() {
        return this.include;
    }

    public void setInclude(Ngram include) {
        this.include = include;
    }

    public Ngram getExclude() {
        return this.exclude;
    }

    public void setExclude(Ngram exclude) {
        this.exclude = exclude;
    }

    public int getPre() {
        return this.pre;
    }

    public void setPre(int pre) {
        this.pre = pre;
    }

    public int getPost() {
        return this.post;
    }

    public void setPost(int post) {
        this.post = post;
    }

    public static List<SpanNotNgram> breakBigram(Ngram ngram) {
        if (ngram.getN() != 2) {
            throw new IllegalArgumentException("n!=2");
        }
        Ngram ngram1 = new Ngram();
        ngram1.setNgram(ngram.getTerms()[0]);
        ngram1.setSlop(0);
        ngram1.setField(ngram.getField());
        ngram1.setInOrder(true);
        Ngram ngram2 = new Ngram();
        ngram2.setNgram(ngram.getTerms()[1]);
        ngram2.setSlop(0);
        ngram2.setField(ngram.getField());
        ngram2.setInOrder(true);
        ArrayList<SpanNotNgram> spanNotNgrams = new ArrayList<SpanNotNgram>();
        SpanNotNgram spanNotNgram1 = new SpanNotNgram();
        spanNotNgram1.setInclude(ngram1);
        spanNotNgram1.setExclude(ngram);
        SpanNotNgram spanNotNgram2 = new SpanNotNgram();
        spanNotNgram2.setInclude(ngram2);
        spanNotNgram2.setExclude(ngram);
        spanNotNgrams.add(spanNotNgram1);
        spanNotNgrams.add(spanNotNgram2);
        return spanNotNgrams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpanNotNgram that = (SpanNotNgram)o;
        if (this.post != that.post) {
            return false;
        }
        if (this.pre != that.pre) {
            return false;
        }
        if (!this.exclude.equals(that.exclude)) {
            return false;
        }
        return this.include.equals(that.include);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.include.hashCode();
        result = 31 * result + this.exclude.hashCode();
        result = 31 * result + this.pre;
        result = 31 * result + this.post;
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SpanNotNgram{");
        sb.append("include=").append(this.include);
        sb.append(", exclude=").append(this.exclude);
        sb.append(", pre=").append(this.pre);
        sb.append(", post=").append(this.post);
        if (this.indexAssigned) {
            sb.append("index=").append(this.index);
        }
        sb.append('}');
        return sb.toString();
    }
}

