/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.util.SetUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonSerialize(using=Serializer.class)
public class Ngram
extends Feature {
    private static final long serialVersionUID = 3L;
    private String ngram = "unknown";
    private String field = "unknown";
    private int slop;
    private boolean inOrder = true;

    public String getNgram() {
        return this.ngram;
    }

    public String[] getTerms() {
        return this.ngram.split(" ");
    }

    public boolean contains(String term) {
        String[] terms;
        for (String str : terms = this.getTerms()) {
            if (!str.equals(term)) continue;
            return true;
        }
        return false;
    }

    public static boolean overlap(Ngram ngram1, Ngram ngram2) {
        HashSet set1 = new HashSet();
        HashSet set2 = new HashSet();
        String[] terms1 = ngram1.getTerms();
        String[] terms2 = ngram2.getTerms();
        Collections.addAll(set1, terms1);
        Collections.addAll(set2, terms2);
        Set intersection = SetUtil.intersect(set1, set2);
        return !intersection.isEmpty();
    }

    public void setNgram(String ngram) {
        this.ngram = ngram;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public int getSlop() {
        return this.slop;
    }

    public void setSlop(int slop) {
        this.slop = slop;
    }

    public int getN() {
        return this.ngram.split(" ").length;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public static String toNgramString(List<String> terms) {
        String str = "";
        for (int i = 0; i < terms.size(); ++i) {
            str = str.concat(terms.get(i));
            if (i == terms.size() - 1) continue;
            str = str.concat(" ");
        }
        return str;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Ngram{");
        if (this.indexAssigned) {
            sb.append("index=").append(this.index).append(",");
        }
        sb.append("name=").append(this.name);
        sb.append(", ngram=").append(this.ngram);
        sb.append(", field=").append(this.field);
        sb.append(", slop=").append(this.slop);
        sb.append(", inOrder=").append(this.inOrder);
        sb.append(", settings=").append(this.settings);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String simpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ngram);
        if (this.slop != 0) {
            sb.append("(").append("slop ").append(this.slop).append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ngram ngram1 = (Ngram)o;
        if (this.inOrder != ngram1.inOrder) {
            return false;
        }
        if (this.slop != ngram1.slop) {
            return false;
        }
        if (!this.field.equals(ngram1.field)) {
            return false;
        }
        return this.ngram.equals(ngram1.ngram);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ngram.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.slop;
        result = 31 * result + (this.inOrder ? 1 : 0);
        return result;
    }

    public static class Serializer
    extends JsonSerializer<Ngram> {
        public void serialize(Ngram feature, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", feature.ngram);
            jsonGenerator.writeNumberField("index", feature.index);
            jsonGenerator.writeStringField("ngram", feature.ngram);
            jsonGenerator.writeStringField("type", "ngram");
            jsonGenerator.writeStringField("field", feature.field);
            jsonGenerator.writeNumberField("slop", feature.slop);
            jsonGenerator.writeBooleanField("inOrder", feature.inOrder);
            jsonGenerator.writeEndObject();
        }
    }
}

