/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.elasticsearch.ESIndex;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class LabelDistribution {
    public static long[] getLabelDistribution(ESIndex index, String labelField, String[] ids, LabelTranslator labelTranslator) {
        int numClasses = labelTranslator.getNumClasses();
        long[] distribution = new long[numClasses];
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{index.getDocumentType()});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)index.getClient().prepareSearch(new String[]{index.getIndexName()}).setSize(0).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)idsFilterBuilder).should((QueryBuilder)QueryBuilders.matchAllQuery())).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(labelField)).size(Integer.MAX_VALUE)).execute().actionGet();
        Terms terms = (Terms)response.getAggregations().get("agg");
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            String extLabel = (String)bucket.getKey();
            long count = bucket.getDocCount();
            int classIndex = labelTranslator.toIntLabel(extLabel);
            distribution[classIndex] = count;
        }
        return distribution;
    }
}

