/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import edu.neu.ccs.pyramid.feature.Feature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FeatureList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Feature> features = new ArrayList<Feature>();

    public FeatureList() {
    }

    public FeatureList(List<Feature> features) {
        this();
        this.addAll(features);
    }

    public Feature get(int featureIndex) {
        return this.features.get(featureIndex);
    }

    public int size() {
        return this.features.size();
    }

    public int nextAvailable() {
        return this.features.size();
    }

    public synchronized void add(Feature feature) {
        int index = this.features.size();
        feature.setIndex(index);
        this.features.add(feature);
    }

    public synchronized void addAll(List<Feature> features) {
        features.forEach(this::add);
    }

    public List<Feature> getAll() {
        return this.features;
    }

    public FeatureList deepCopy() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (FeatureList)ois.readObject();
    }

    public void clearInices() {
        for (Feature feature : this.features) {
            feature.clearIndex();
        }
    }
}

