/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
public class Feature
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected boolean indexAssigned;
    protected int index;
    protected String name = "unknown";
    protected Map<String, String> settings = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        if (!this.indexAssigned) {
            throw new RuntimeException("feature index is not yet assigned");
        }
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.indexAssigned = true;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public boolean isIndexAssigned() {
        return this.indexAssigned;
    }

    public void clearIndex() {
        this.indexAssigned = false;
        this.index = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Feature{");
        if (this.indexAssigned) {
            sb.append("index=").append(this.index);
        }
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", settings=").append(this.settings);
        sb.append('}');
        return sb.toString();
    }

    public String simpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(").append("numerical").append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        if (this.index != feature.index) {
            return false;
        }
        if (this.indexAssigned != feature.indexAssigned) {
            return false;
        }
        return this.name.equals(feature.name);
    }

    public int hashCode() {
        int result = this.indexAssigned ? 1 : 0;
        result = 31 * result + this.index;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public static class Serializer
    extends JsonSerializer<Feature> {
        public void serialize(Feature feature, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", feature.name);
            jsonGenerator.writeStringField("type", "numerical");
            jsonGenerator.writeEndObject();
        }
    }
}

