/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import edu.neu.ccs.pyramid.feature.CategoricalFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CategoricalFeatureExpander {
    private Set<String> categories = Collections.newSetFromMap(new ConcurrentHashMap());
    private int start;
    private boolean startSet = false;
    private String variableName;
    private Map<String, String> commonSettings = new HashMap<String, String>();

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void setStart(int start) {
        this.start = start;
        this.startSet = true;
    }

    public void putSetting(String key, String value) {
        this.commonSettings.put(key, value);
    }

    public List<CategoricalFeature> expand() {
        if (!this.startSet) {
            throw new RuntimeException("start is not set yet!");
        }
        ArrayList<CategoricalFeature> features = new ArrayList<CategoricalFeature>();
        HashMap<String, Integer> categoryIndexMap = new HashMap<String, Integer>();
        ArrayList<String> sortedCats = new ArrayList<String>(this.categories.size());
        sortedCats.addAll(this.categories);
        Collections.sort(sortedCats);
        int pos = this.start;
        for (String category : sortedCats) {
            CategoricalFeature feature = new CategoricalFeature();
            feature.setVariableName(this.variableName);
            feature.setCategory(category);
            feature.setCategoryIndexMap(categoryIndexMap);
            feature.setNumCategories(this.categories.size());
            feature.setIndex(pos);
            feature.setName(this.variableName + "[" + category + "]");
            for (Map.Entry<String, String> entry : this.commonSettings.entrySet()) {
                feature.getSettings().put(entry.getKey(), entry.getValue());
            }
            categoryIndexMap.put(category, pos);
            features.add(feature);
            ++pos;
        }
        return features;
    }
}

