/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.feature;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.neu.ccs.pyramid.feature.Feature;
import java.io.IOException;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
public class CategoricalFeature
extends Feature {
    private String category;
    private int numCategories;
    private String variableName;
    private Map<String, Integer> categoryIndexMap;

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public int getNumCategories() {
        return this.numCategories;
    }

    public void setNumCategories(int numCategories) {
        this.numCategories = numCategories;
    }

    public Map<String, Integer> getCategoryIndexMap() {
        return this.categoryIndexMap;
    }

    public void setCategoryIndexMap(Map<String, Integer> categoryIndexMap) {
        this.categoryIndexMap = categoryIndexMap;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CategoricalFeature{");
        sb.append(super.toString()).append(", ");
        sb.append("category='").append(this.category).append('\'');
        sb.append(", numCategories=").append(this.numCategories);
        sb.append(", variableName='").append(this.variableName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String simpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("[").append(this.variableName).append("]").append("(").append("categorical").append(")");
        return sb.toString();
    }

    public static class Serializer
    extends JsonSerializer<CategoricalFeature> {
        public void serialize(CategoricalFeature feature, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", feature.name);
            jsonGenerator.writeStringField("type", "categorical");
            jsonGenerator.writeStringField("variable", feature.variableName);
            jsonGenerator.writeNumberField("numCategories", feature.numCategories);
            jsonGenerator.writeStringField("category", feature.category);
            jsonGenerator.writeEndObject();
        }
    }
}

