/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.SafeDivide;
import edu.neu.ccs.pyramid.multilabel_classification.MultiLabelClassifier;

public class Recall {
    public static double recall(double tp, double fn) {
        return SafeDivide.divide(tp, tp + fn, 1.0);
    }

    public static double recall(Classifier classifier, ClfDataSet dataSet, int k) {
        int[] labels = dataSet.getLabels();
        int[] predictions = classifier.predict(dataSet);
        return Recall.recall(labels, predictions, k);
    }

    public static double recall(int[] labels, int[] predictions, int k) {
        int falseNegative = 0;
        int truePositives = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] != k) continue;
            if (predictions[i] == k) {
                ++truePositives;
                continue;
            }
            ++falseNegative;
        }
        return Recall.recall(truePositives, falseNegative);
    }

    @Deprecated
    public static double recall(MultiLabel[] multiLabels, MultiLabel[] predictions) {
        double r = 0.0;
        for (int i = 0; i < multiLabels.length; ++i) {
            MultiLabel label = multiLabels[i];
            MultiLabel prediction = predictions[i];
            if (label.getMatchedLabels().size() == 0) {
                r += 1.0;
                continue;
            }
            r += (double)MultiLabel.intersection(label, prediction).size() * 1.0 / (double)label.getMatchedLabels().size();
        }
        return r / (double)multiLabels.length;
    }

    @Deprecated
    public static double recall(MultiLabelClassifier classifier, MultiLabelClfDataSet dataset) {
        return Recall.recall(dataset.getMultiLabels(), classifier.predict(dataset));
    }
}

