/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.eval.ConfusionMatrix;
import edu.neu.ccs.pyramid.eval.FMeasure;

public class PerClassMeasures {
    private int classIndex;
    private String className = "unknown";
    private int positive;
    private int negative;
    private int truePositive;
    private int trueNegative;
    private int falsePositive;
    private int falseNegative;
    private double truePositiveRate;
    private double trueNegativeRate;
    private double falsePositiveRate;
    private double falseNegativeRate;
    private double accuracy;
    private double precision;
    private double recall;
    private double f1;

    public PerClassMeasures(ConfusionMatrix confusionMatrix, int classIndex) {
        this.classIndex = classIndex;
        int numClasses = confusionMatrix.getNumClasses();
        int[][] matrix = confusionMatrix.getMatrix();
        for (int label = 0; label < numClasses; ++label) {
            for (int prediction = 0; prediction < numClasses; ++prediction) {
                int count = matrix[label][prediction];
                if (label == classIndex && prediction == classIndex) {
                    this.truePositive += count;
                }
                if (label == classIndex && prediction != classIndex) {
                    this.falseNegative += count;
                }
                if (label != classIndex && prediction == classIndex) {
                    this.falsePositive += count;
                }
                if (label == classIndex || prediction == classIndex) continue;
                this.trueNegative += count;
            }
        }
        this.positive = this.truePositive + this.falseNegative;
        this.negative = this.trueNegative + this.falsePositive;
        this.truePositiveRate = (double)this.truePositive / (double)this.positive;
        this.trueNegativeRate = (double)this.trueNegative / (double)this.negative;
        this.falsePositiveRate = (double)this.falsePositive / (double)this.negative;
        this.falseNegativeRate = (double)this.falseNegative / (double)this.positive;
        this.accuracy = (double)(this.truePositive + this.trueNegative) / (double)(this.positive + this.negative);
        this.precision = (double)this.truePositive / (double)(this.truePositive + this.falsePositive);
        this.recall = this.truePositiveRate;
        this.f1 = FMeasure.f1(this.precision, this.recall);
    }

    public PerClassMeasures(ConfusionMatrix confusionMatrix, int classIndex, String className) {
        this(confusionMatrix, classIndex);
        this.className = className;
    }

    public PerClassMeasures(MultiLabel[] multiLabels, MultiLabel[] predictions, int classIndex) {
        this(PerClassMeasures.getBinaryConfusionMatrix(multiLabels, predictions, classIndex), 1);
    }

    public PerClassMeasures(MultiLabel[] multiLabels, MultiLabel[] predictions, int classIndex, String className) {
        this(multiLabels, predictions, classIndex);
        this.className = className;
    }

    public int getPositive() {
        return this.positive;
    }

    public int getNegative() {
        return this.negative;
    }

    public int getTruePositive() {
        return this.truePositive;
    }

    public int getTrueNegative() {
        return this.trueNegative;
    }

    public int getFalsePositive() {
        return this.falsePositive;
    }

    public int getFalseNegative() {
        return this.falseNegative;
    }

    public double getTruePositiveRate() {
        return this.truePositiveRate;
    }

    public double getTrueNegativeRate() {
        return this.trueNegativeRate;
    }

    public double getFalsePositiveRate() {
        return this.falsePositiveRate;
    }

    public double getFalseNegativeRate() {
        return this.falseNegativeRate;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getF1() {
        return this.f1;
    }

    public String toString() {
        return "{classIndex=" + this.classIndex + ", className=" + this.className + ", positive=" + this.positive + ", negative=" + this.negative + ", truePositive=" + this.truePositive + ", trueNegative=" + this.trueNegative + ", falsePositive=" + this.falsePositive + ", falseNegative=" + this.falseNegative + ", truePositiveRate=" + this.truePositiveRate + ", trueNegativeRate=" + this.trueNegativeRate + ", falsePositiveRate=" + this.falsePositiveRate + ", falseNegativeRate=" + this.falseNegativeRate + ", accuracy=" + this.accuracy + ", precision=" + this.precision + ", recall=" + this.recall + ", f1=" + this.f1 + '}';
    }

    private static ConfusionMatrix getBinaryConfusionMatrix(MultiLabel[] multiLabels, MultiLabel[] predictions, int classIndex) {
        int numDataPoints = multiLabels.length;
        int[] binaryLabels = new int[numDataPoints];
        int[] binaryPredictions = new int[numDataPoints];
        for (int i = 0; i < numDataPoints; ++i) {
            binaryLabels[i] = multiLabels[i].matchClass(classIndex) ? 1 : 0;
            binaryPredictions[i] = predictions[i].matchClass(classIndex) ? 1 : 0;
        }
        ConfusionMatrix confusionMatrix = new ConfusionMatrix(2, binaryLabels, binaryPredictions);
        return confusionMatrix;
    }
}

