/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.util.ArgSort;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.FastMath;

public class NDCG {
    public static double ndcg(int[] gradesInRandedList, int truncation) {
        int truncationUsed = truncation;
        if (truncation > gradesInRandedList.length) {
            System.out.println("Warning: truncation " + truncation + " is bigger than the list length " + gradesInRandedList.length + ". Try to use the list length as truncation");
            truncationUsed = gradesInRandedList.length;
        }
        return NDCG.dcg(gradesInRandedList, truncationUsed) / NDCG.idcg(gradesInRandedList, truncationUsed);
    }

    public static double ndcg(int[] gradesInRandedList) {
        int truncation = gradesInRandedList.length;
        return NDCG.ndcg(gradesInRandedList, truncation);
    }

    public static double ndcg(int[] labels, double[] scores, int truncation) {
        if (labels.length != scores.length) {
            throw new IllegalArgumentException("lengths are different");
        }
        int numData = labels.length;
        int[] sortedIndices = ArgSort.argSortDescending(scores);
        int[] gradesSortedWithScores = new int[numData];
        for (int i = 0; i < numData; ++i) {
            gradesSortedWithScores[i] = labels[sortedIndices[i]];
        }
        return NDCG.ndcg(gradesSortedWithScores, truncation);
    }

    public static double ndcg(int[] labels, double[] scores) {
        return NDCG.ndcg(labels, scores, labels.length);
    }

    private static double idcg(int[] gradesInRandedList, int truncation) {
        int[] sortedGrades = Arrays.copyOf(gradesInRandedList, gradesInRandedList.length);
        Arrays.sort(sortedGrades);
        ArrayUtils.reverse((int[])sortedGrades);
        return NDCG.dcg(sortedGrades, truncation);
    }

    private static double dcg(int[] gradesInRandedList, int truncation) {
        return IntStream.range(0, truncation).parallel().mapToDouble(i -> {
            double nominator = FastMath.pow((double)2.0, (int)gradesInRandedList[i]) - 1.0;
            double denominator = FastMath.log((double)2.0, (double)(i + 2));
            return nominator / denominator;
        }).sum();
    }
}

