/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.eval.ConfusionMatrixMeasures;
import edu.neu.ccs.pyramid.eval.FMeasure;
import edu.neu.ccs.pyramid.eval.LabelBasedMeasures;
import edu.neu.ccs.pyramid.eval.Precision;
import edu.neu.ccs.pyramid.eval.Recall;
import java.util.stream.IntStream;

public class MicroMeasures
extends LabelBasedMeasures {
    public MicroMeasures(int numLabels) {
        super(numLabels);
    }

    public double getPrecision() {
        int tp = IntStream.of(this.truePositives).sum();
        int fp = IntStream.of(this.falsePositives).sum();
        return Precision.precision(tp, fp);
    }

    public double getRecall() {
        int tp = IntStream.of(this.truePositives).sum();
        int fn = IntStream.of(this.falseNegatives).sum();
        return Recall.recall(tp, fn);
    }

    public double getSpecificity() {
        int tn = IntStream.of(this.trueNegatives).sum();
        int fp = IntStream.of(this.falsePositives).sum();
        return ConfusionMatrixMeasures.specificity(tn, fp);
    }

    public double getFScore(double beta) {
        int tp = IntStream.of(this.truePositives).sum();
        int fp = IntStream.of(this.falsePositives).sum();
        int fn = IntStream.of(this.falseNegatives).sum();
        return FMeasure.fBeta(tp, fp, fn, beta);
    }

    public double getF1Score() {
        return this.getFScore(1.0);
    }

    @Override
    public String toString() {
        return "Micro-Precision: \t" + this.getPrecision() + "\nMicro-Recall: \t" + this.getRecall() + "\nMicro-Specificity: \t" + this.getSpecificity() + "\nMicro-F1Score: \t" + this.getF1Score();
    }
}

