/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.eval.ConfusionMatrix;
import edu.neu.ccs.pyramid.eval.FMeasure;
import edu.neu.ccs.pyramid.eval.PerClassMeasures;

public class MicroAveragedMeasures {
    private int positive;
    private int negative;
    private int truePositive;
    private int trueNegative;
    private int falsePositive;
    private int falseNegative;
    private double truePositiveRate;
    private double trueNegativeRate;
    private double falsePositiveRate;
    private double falseNegativeRate;
    private double accuracy;
    private double precision;
    private double recall;
    private double f1;

    public MicroAveragedMeasures(ConfusionMatrix confusionMatrix) {
        int numClass = confusionMatrix.getNumClasses();
        for (int k = 0; k < numClass; ++k) {
            PerClassMeasures measures = new PerClassMeasures(confusionMatrix, k);
            this.truePositive += measures.getTruePositive();
            this.trueNegative += measures.getTrueNegative();
            this.falsePositive += measures.getFalsePositive();
            this.falseNegative += measures.getFalseNegative();
        }
        this.positive = this.truePositive + this.falseNegative;
        this.negative = this.trueNegative + this.falsePositive;
        this.truePositiveRate = (double)this.truePositive / (double)this.positive;
        this.trueNegativeRate = (double)this.trueNegative / (double)this.negative;
        this.falsePositiveRate = (double)this.falsePositive / (double)this.negative;
        this.falseNegativeRate = (double)this.falseNegative / (double)this.positive;
        this.accuracy = (double)(this.truePositive + this.trueNegative) / (double)(this.positive + this.negative);
        this.precision = (double)this.truePositive / (double)(this.truePositive + this.falsePositive);
        this.recall = this.truePositiveRate;
        this.f1 = FMeasure.f1(this.precision, this.recall);
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getF1() {
        return this.f1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MicroAveragedMeasures{").append("\n");
        sb.append("accuracy=").append(this.accuracy).append("\n");
        sb.append(", precision=").append(this.precision).append("\n");
        sb.append(", recall=").append(this.recall).append("\n");
        sb.append(", f1=").append(this.f1).append("\n");
        sb.append('}');
        return sb.toString();
    }
}

