/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.eval.FMeasure;
import edu.neu.ccs.pyramid.eval.HammingLoss;
import edu.neu.ccs.pyramid.eval.MLConfusionMatrix;
import edu.neu.ccs.pyramid.eval.Overlap;
import edu.neu.ccs.pyramid.eval.Precision;
import edu.neu.ccs.pyramid.eval.Recall;
import org.apache.mahout.math.Vector;

public class MicroAverage {
    private double f1;
    private double overlap;
    private double precision;
    private double recall;
    private double hammingLoss;

    public MicroAverage(MLConfusionMatrix confusionMatrix) {
        int numClasses = confusionMatrix.getNumClasses();
        int numDataPoints = confusionMatrix.getNumDataPoints();
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        DataSet entries = confusionMatrix.getEntries();
        for (int i = 0; i < numDataPoints; ++i) {
            for (Vector.Element element : entries.getRow(i).nonZeroes()) {
                double v = element.get();
                if (v == 1.0) {
                    tp += 1.0;
                    continue;
                }
                if (v == 2.0) {
                    fn += 1.0;
                    continue;
                }
                if (v != 3.0) continue;
                fp += 1.0;
            }
        }
        tn = (double)(numDataPoints * numClasses) - tp - fp - fn;
        this.precision = Precision.precision(tp, fp);
        this.recall = Recall.recall(tp, fn);
        this.f1 = FMeasure.f1(tp, fp, fn);
        this.overlap = Overlap.overlap(tp, fp, fn);
        this.hammingLoss = HammingLoss.hammingLoss(tp, tn, fp, fn);
    }

    public double getF1() {
        return this.f1;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getHammingLoss() {
        return this.hammingLoss;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("micro Jaccard index = ").append(this.overlap).append("\n");
        sb.append("micro Hamming loss = ").append(this.hammingLoss).append("\n");
        sb.append("micro F1 = ").append(this.f1).append("\n");
        sb.append("micro precision = ").append(this.precision).append("\n");
        sb.append("micro recall = ").append(this.recall).append("\n");
        return sb.toString();
    }
}

