/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.ConfusionMatrixMeasures;
import edu.neu.ccs.pyramid.eval.FMeasure;
import edu.neu.ccs.pyramid.eval.LabelBasedMeasures;
import edu.neu.ccs.pyramid.eval.Precision;
import edu.neu.ccs.pyramid.eval.Recall;

public class MacroMeasures
extends LabelBasedMeasures {
    public MacroMeasures(int numLabels) {
        super(numLabels);
    }

    public MacroMeasures(MultiLabelClfDataSet dataSet, MultiLabel[] prediction) {
        super(dataSet, prediction);
    }

    public double getPrecision() {
        double sum = 0.0;
        for (int i = 0; i < this.numLabels; ++i) {
            sum += Precision.precision(this.truePositives[i], this.falsePositives[i]);
        }
        return sum / (double)this.numLabels;
    }

    public double getPrecision(int labelIndex) {
        return Precision.precision(this.truePositives[labelIndex], this.falsePositives[labelIndex]);
    }

    public double getRecall() {
        double sum = 0.0;
        for (int i = 0; i < this.numLabels; ++i) {
            sum += Recall.recall(this.truePositives[i], this.falseNegatives[i]);
        }
        return sum / (double)this.numLabels;
    }

    public double getRecall(int labelIndex) {
        return Recall.recall(this.truePositives[labelIndex], this.falseNegatives[labelIndex]);
    }

    public double getSpecificity() {
        double sum = 0.0;
        for (int i = 0; i < this.numLabels; ++i) {
            sum += ConfusionMatrixMeasures.specificity(this.trueNegatives[i], this.falsePositives[i]);
        }
        return sum / (double)this.numLabels;
    }

    public double getSpecificity(int labelIndex) {
        return ConfusionMatrixMeasures.specificity(this.trueNegatives[labelIndex], this.falsePositives[labelIndex]);
    }

    public double getFScore(double beta) {
        double sum = 0.0;
        for (int i = 0; i < this.numLabels; ++i) {
            sum += this.getFScore(beta, i);
        }
        return sum / (double)this.numLabels;
    }

    public double getFScore(double beta, int labelIndex) {
        double precision = this.getPrecision(labelIndex);
        double recall = this.getRecall(labelIndex);
        return FMeasure.fBeta(precision, recall, beta);
    }

    public double getF1Score() {
        return this.getFScore(1.0);
    }

    public double getF1Score(int labelIndex) {
        return this.getFScore(1.0, labelIndex);
    }

    @Override
    public String toString() {
        return "Macro-Precision: \t" + this.getPrecision() + "\nMacro-Recall: \t" + this.getRecall() + "\nMacro-Specificity: \t" + this.getSpecificity() + "\nMacro-F1Score: \t" + this.getF1Score();
    }
}

