/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.ConfusionMatrix;
import edu.neu.ccs.pyramid.eval.PerClassMeasures;
import edu.neu.ccs.pyramid.multilabel_classification.MultiLabelClassifier;

public class MacroAveragedMeasures {
    private double f1;

    public MacroAveragedMeasures(ConfusionMatrix confusionMatrix) {
        int numClasses = confusionMatrix.getNumClasses();
        double sum = 0.0;
        for (int k = 0; k < numClasses; ++k) {
            PerClassMeasures measures = new PerClassMeasures(confusionMatrix, k);
            sum += measures.getF1();
        }
        this.f1 = sum / (double)numClasses;
    }

    public MacroAveragedMeasures(MultiLabelClassifier classifier, MultiLabelClfDataSet dataSet) {
        int numClasses = dataSet.getNumClasses();
        MultiLabel[] multiLabels = dataSet.getMultiLabels();
        MultiLabel[] predictions = classifier.predict(dataSet);
        double sum = 0.0;
        for (int k = 0; k < numClasses; ++k) {
            PerClassMeasures measures = new PerClassMeasures(multiLabels, predictions, k);
            sum += measures.getF1();
        }
        this.f1 = sum / (double)numClasses;
    }

    public double getF1() {
        return this.f1;
    }

    public String toString() {
        return "MacroAveragedMeasures{f1=" + this.f1 + '}';
    }
}

