/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.util.ArgSort;
import java.util.stream.IntStream;

public class MRR {
    public static double mrr(Classifier.ProbabilityEstimator probabilityEstimator, ClfDataSet clfDataSet) {
        int[] labels = clfDataSet.getLabels();
        return IntStream.range(0, clfDataSet.getNumDataPoints()).parallel().mapToDouble(i -> MRR.reciprocalRank(labels[i], probabilityEstimator.predictClassProbs(clfDataSet.getRow(i)))).average().getAsDouble();
    }

    static double reciprocalRank(int label, double[] measures) {
        int[] rankedIndices = ArgSort.argSortDescending(measures);
        return MRR.reciprocalRank(label, rankedIndices);
    }

    static double reciprocalRank(int label, int[] rankedIndices) {
        int i = 0;
        while (label != rankedIndices[i]) {
            ++i;
        }
        return 1.0 / (double)(i + 1);
    }
}

