/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.eval.Precision;
import edu.neu.ccs.pyramid.eval.Recall;

public class FMeasure {
    public static double fBeta(double tp, double fp, double fn, double beta) {
        double precision = Precision.precision(tp, fp);
        double recall = Recall.recall(tp, fn);
        return FMeasure.fBeta(precision, recall, beta);
    }

    public static double fBeta(double precision, double recall, double beta) {
        if (precision == 0.0 || recall == 0.0) {
            return 0.0;
        }
        return (1.0 + beta * beta) * precision * recall / (beta * beta * precision + recall);
    }

    public static double f1(double tp, double fp, double fn) {
        return FMeasure.fBeta(tp, fp, fn, 1.0);
    }

    public static double f1(double precision, double recall) {
        return FMeasure.fBeta(precision, recall, 1.0);
    }

    @Deprecated
    public static double f1(MultiLabel[] multiLabels, MultiLabel[] predictions) {
        double f = 0.0;
        for (int i = 0; i < multiLabels.length; ++i) {
            MultiLabel label = multiLabels[i];
            MultiLabel prediction = predictions[i];
            f += (double)MultiLabel.intersection(label, prediction).size() * 2.0 / (double)(label.getMatchedLabels().size() + prediction.getMatchedLabels().size());
        }
        return f / (double)multiLabels.length;
    }
}

