/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;

public class ConfusionMatrix {
    private int[][] matrix;
    private int numClasses;
    private LabelTranslator labelTranslator;
    private int[] total;

    public ConfusionMatrix(int numClasses, int[] labels, int[] predictions) {
        this.numClasses = numClasses;
        this.matrix = new int[numClasses][numClasses];
        this.total = new int[numClasses];
        int numDataPoints = labels.length;
        for (int i = 0; i < numDataPoints; ++i) {
            int label = labels[i];
            int prediction = predictions[i];
            int[] nArray = this.matrix[label];
            int n = prediction;
            nArray[n] = nArray[n] + 1;
            int n2 = label;
            this.total[n2] = this.total[n2] + 1;
        }
    }

    public ConfusionMatrix(Classifier classifier, ClfDataSet dataSet) {
        this(dataSet.getNumClasses(), dataSet.getLabels(), classifier.predict(dataSet));
        this.labelTranslator = dataSet.getLabelTranslator();
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public String printWithIntLabels() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (int k = 0; k < this.numClasses; ++k) {
            sb.append(k).append("\t");
        }
        sb.append("\n");
        for (int i = 0; i < this.numClasses; ++i) {
            sb.append(i).append("\t");
            for (int j = 0; j < this.numClasses; ++j) {
                sb.append(this.matrix[i][j]).append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String printWithExtLabels() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int i = 0; i < this.numClasses; ++i) {
            sb.append(this.labelTranslator.toExtLabel(i)).append("(").append(this.total[i]).append(")").append("=>").append("   ");
            for (int j = 0; j < this.numClasses; ++j) {
                sb.append(this.labelTranslator.toExtLabel(j)).append(":").append(this.matrix[i][j]).append("   ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

