/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.eval;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.util.ArgSort;
import java.util.stream.IntStream;

public class AppearanceAtTop {
    public static double rate(Classifier.ProbabilityEstimator probabilityEstimator, ClfDataSet clfDataSet, int top) {
        int[] labels = clfDataSet.getLabels();
        long total = IntStream.range(0, clfDataSet.getNumDataPoints()).parallel().filter(i -> AppearanceAtTop.appear(labels[i], probabilityEstimator.predictClassProbs(clfDataSet.getRow(i)), top)).count();
        return (double)total / (double)clfDataSet.getNumDataPoints();
    }

    static boolean appear(int label, double[] measures, int top) {
        int[] rankedIndices = ArgSort.argSortDescending(measures);
        return AppearanceAtTop.appear(label, rankedIndices, top);
    }

    static boolean appear(int label, int[] rankedIndices, int top) {
        if (top < 1) {
            throw new IllegalArgumentException("top must be at least 1");
        }
        for (int i = 0; i < top; ++i) {
            if (rankedIndices[i] != label) continue;
            return true;
        }
        return false;
    }
}

