/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.elasticsearch;

public class TermStat {
    private String term;
    private int tf = 0;
    private int df = 0;
    private float tfidf = 0.0f;

    public TermStat(String term) {
        this.term = term;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public int getTf() {
        return this.tf;
    }

    public TermStat setTf(int tf) {
        this.tf = tf;
        return this;
    }

    public int getDf() {
        return this.df;
    }

    public TermStat setDf(int df) {
        this.df = df;
        return this;
    }

    public float getTfidf() {
        return this.tfidf;
    }

    public TermStat setTfidf(float tfidf) {
        this.tfidf = tfidf;
        return this;
    }

    public static TermStat combine(TermStat termStat1, TermStat termStat2) {
        if (!termStat1.term.equals(termStat2.term)) {
            throw new IllegalArgumentException("!termStat1.term.equals(termStat2.term)");
        }
        TermStat termStat = new TermStat(termStat1.term);
        termStat.tf = termStat1.tf + termStat2.tf;
        termStat.df = termStat1.df;
        termStat.tfidf = termStat1.tfidf + termStat2.tfidf;
        return termStat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermStat termStat = (TermStat)o;
        return this.term.equals(termStat.term);
    }

    public int hashCode() {
        return this.term.hashCode();
    }

    public String toString() {
        return "TermStat{term='" + this.term + '\'' + ", tf=" + this.tf + ", df=" + this.df + ", tfidf=" + this.tfidf + '}';
    }
}

