/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.elasticsearch;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.IdTranslator;
import edu.neu.ccs.pyramid.elasticsearch.ESIndex;
import edu.neu.ccs.pyramid.feature.CategoricalFeature;
import edu.neu.ccs.pyramid.feature.CodeDescription;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.feature.Ngram;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public class FeatureLoader {
    public static void loadFeatures(ESIndex index, DataSet dataSet, FeatureList features, IdTranslator idTranslator, MatchScoreType matchScoreType, String docFilter) {
        IntStream.range(0, features.size()).parallel().forEach(i -> {
            Feature feature = features.get(i);
            if (feature instanceof CategoricalFeature) {
                FeatureLoader.loadCategoricalFeature(index, dataSet, (CategoricalFeature)feature, idTranslator, docFilter);
            } else if (feature instanceof Ngram) {
                FeatureLoader.loadNgramFeature(index, dataSet, (Ngram)feature, idTranslator, matchScoreType, docFilter);
            } else if (feature instanceof CodeDescription) {
                FeatureLoader.loadCodeDesFeature(index, dataSet, feature, idTranslator, docFilter);
            } else {
                FeatureLoader.loadNumericalFeature(index, dataSet, feature, idTranslator);
            }
        });
    }

    public static void loadCategoricalFeature(ESIndex index, DataSet dataSet, CategoricalFeature feature, IdTranslator idTranslator, String docFilter) {
        String[] dataIndexIds = idTranslator.getAllExtIds();
        String variableName = feature.getVariableName();
        int featureIndex = feature.getIndex();
        List<String> matchedIds = null;
        try {
            matchedIds = index.termFilter(variableName, feature.getCategory(), docFilter, idTranslator.numData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String matchedId : matchedIds) {
            int algorithmId = idTranslator.toIntId(matchedId);
            dataSet.setFeatureValue(algorithmId, featureIndex, 1.0);
        }
        List<String> docMissingField = index.docsWithFieldMissing(variableName, dataIndexIds);
        for (String extId : docMissingField) {
            int algorithmId = idTranslator.toIntId(extId);
            dataSet.setFeatureValue(algorithmId, featureIndex, Double.NaN);
        }
    }

    public static void loadNgramFeature(ESIndex index, DataSet dataSet, Ngram feature, IdTranslator idTranslator, MatchScoreType matchScoreType, String docFilter) {
        switch (matchScoreType) {
            case ES_ORIGINAL: {
                FeatureLoader.loadNgramFeatureOriginal(index, dataSet, feature, idTranslator, docFilter);
                break;
            }
            case BINARY: {
                FeatureLoader.loadNgramFeatureBinary(index, dataSet, feature, idTranslator, docFilter);
                break;
            }
            case FREQUENCY: {
                FeatureLoader.loadNgramFeatureFrequency(index, dataSet, feature, idTranslator, docFilter);
                break;
            }
            case TFIFL: {
                FeatureLoader.loadNgramFeatureTFIFL(index, dataSet, feature, idTranslator, docFilter);
            }
        }
    }

    private static void loadNgramFeatureOriginal(ESIndex index, DataSet dataSet, Ngram feature, IdTranslator idTranslator, String docFilter) {
        SearchHit[] hits;
        int featureIndex = feature.getIndex();
        SearchResponse response = index.spanNear(feature, docFilter, idTranslator.numData());
        for (SearchHit hit : hits = response.getHits().getHits()) {
            String indexId = hit.getId();
            float score = hit.getScore();
            int algorithmId = idTranslator.toIntId(indexId);
            dataSet.setFeatureValue(algorithmId, featureIndex, score);
        }
    }

    private static void loadNgramFeatureFrequency(ESIndex index, DataSet dataSet, Ngram feature, IdTranslator idTranslator, String docFilter) {
        SearchHit[] hits;
        int featureIndex = feature.getIndex();
        SearchResponse response = index.spanNearFrequency(feature, docFilter, idTranslator.numData());
        for (SearchHit hit : hits = response.getHits().getHits()) {
            String indexId = hit.getId();
            float score = hit.getScore();
            int algorithmId = idTranslator.toIntId(indexId);
            dataSet.setFeatureValue(algorithmId, featureIndex, score);
        }
    }

    private static void loadNgramFeatureTFIFL(ESIndex index, DataSet dataSet, Ngram feature, IdTranslator idTranslator, String docFilter) {
        int featureIndex = feature.getIndex();
        SearchResponse response = index.spanNearFrequency(feature, docFilter, idTranslator.numData());
        SearchHit[] hits = response.getHits().getHits();
        String field = feature.getField();
        String lengthField = field + "_field_length";
        for (SearchHit hit : hits) {
            String indexId = hit.getId();
            float score = hit.getScore();
            float docLength = index.getFloatField(indexId, lengthField);
            double s = score / docLength;
            int algorithmId = idTranslator.toIntId(indexId);
            dataSet.setFeatureValue(algorithmId, featureIndex, s);
        }
    }

    public static void loadNgramFeatureBinary(ESIndex index, DataSet dataSet, Ngram feature, IdTranslator idTranslator, String docFilter) {
        SearchHit[] hits;
        int featureIndex = feature.getIndex();
        SearchResponse response = index.spanNear(feature, docFilter, idTranslator.numData());
        for (SearchHit hit : hits = response.getHits().getHits()) {
            String indexId = hit.getId();
            float score = hit.getScore();
            int algorithmId = idTranslator.toIntId(indexId);
            if (score > 0.0f) {
                score = 1.0f;
            }
            dataSet.setFeatureValue(algorithmId, featureIndex, score);
        }
    }

    public static void loadNumericalFeature(ESIndex index, DataSet dataSet, Feature feature, IdTranslator idTranslator) {
        String[] dataIndexIds = idTranslator.getAllExtIds();
        String variableName = feature.getName();
        int featureIndex = feature.getIndex();
        String source = feature.getSettings().get("source");
        if (source.equals("field")) {
            Arrays.stream(dataIndexIds).forEach(id -> {
                int algorithmId = idTranslator.toIntId((String)id);
                double value = index.getFloatField((String)id, variableName);
                dataSet.setFeatureValue(algorithmId, featureIndex, value);
            });
        }
    }

    private static void loadCodeDesFeature(ESIndex index, DataSet dataSet, Feature feature, IdTranslator idTranslator, String docFilter) {
        SearchHit[] hits;
        String[] dataIndexIds = idTranslator.getAllExtIds();
        int featureIndex = feature.getIndex();
        CodeDescription codeDescription = (CodeDescription)feature;
        SearchResponse response = index.minimumShouldMatch(codeDescription.getDescription(), codeDescription.getField(), codeDescription.getPercentage(), idTranslator.numData(), docFilter);
        for (SearchHit hit : hits = response.getHits().getHits()) {
            String indexId = hit.getId();
            float score = hit.getScore();
            int algorithmId = idTranslator.toIntId(indexId);
            dataSet.setFeatureValue(algorithmId, featureIndex, score);
        }
    }

    public static enum MatchScoreType {
        ES_ORIGINAL,
        BINARY,
        FREQUENCY,
        TFIFL;

    }
}

