/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.elasticsearch;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.neu.ccs.pyramid.elasticsearch.TermStat;
import edu.neu.ccs.pyramid.esplugins.PhraseCountQueryBuilder;
import edu.neu.ccs.pyramid.feature.Ngram;
import edu.neu.ccs.pyramid.feature.SpanNotNgram;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.elasticsearch.index.query.SpanNotQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.index.query.SpanTermQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class ESIndex
implements AutoCloseable {
    public static final String STRING_MISSING_VALUE = "MISSING";
    private static final Logger logger = LogManager.getLogger();
    Client client;
    Node node;
    String indexName;
    int numDocs;
    String documentType;
    String clientType;
    String clusterName;
    String bodyField;
    LoadingCache<String, Map<Integer, String>> termVectorCache;

    public int getNumDocs() {
        return this.numDocs;
    }

    public List<String> getAllDocs() {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        ArrayList<String> list = new ArrayList<String>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            list.add(searchHit.getId());
        }
        return list;
    }

    public Client getClient() {
        return this.client;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBodyField() {
        return this.bodyField;
    }

    public Set<String> getTerms(String id) throws IOException {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        TermVectorsResponse response = (TermVectorsResponse)this.client.prepareTermVector(this.indexName, this.documentType, id).setOffsets(false).setPositions(false).setFieldStatistics(false).setSelectedFields(new String[]{this.bodyField}).execute().actionGet();
        Terms terms = response.getFields().terms(this.bodyField);
        TermsEnum iterator = terms.iterator();
        HashSet<String> termsSet = new HashSet<String>();
        int i = 0;
        while ((long)i < terms.size()) {
            String term = iterator.next().utf8ToString();
            termsSet.add(term);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time spent on getNgrams from doc " + id + " = " + stopWatch + " It has " + termsSet.size() + " ngrams");
        }
        return termsSet;
    }

    public List<String> getDocs(String term, String[] ids) throws Exception {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        TermQueryBuilder termFilterBuilder = new TermQueryBuilder(this.bodyField, term);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(ids.length).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)termFilterBuilder).filter((QueryBuilder)idsFilterBuilder))).execute().actionGet();
        ArrayList<String> list = new ArrayList<String>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            list.add(searchHit.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time spent on termFilter() for " + term + " = " + stopWatch + " There are " + list.size() + " matched docs");
        }
        return list;
    }

    public List<String> termFilter(String field, String term) throws Exception {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        TermQueryBuilder termFilterBuilder = new TermQueryBuilder(field, term);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)termFilterBuilder)).execute().actionGet();
        ArrayList<String> list = new ArrayList<String>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            list.add(searchHit.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time spent on termFilter() for " + term + " = " + stopWatch + " There are " + list.size() + " matched docs");
        }
        return list;
    }

    public List<String> matchStringQuery(String query) {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setQuery((QueryBuilder)QueryBuilders.wrapperQuery((String)query)).execute().actionGet();
        ArrayList<String> list = new ArrayList<String>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            list.add(searchHit.getId());
        }
        return list;
    }

    public SearchResponse submitQuery(String query) {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.wrapperQuery((String)query)).execute().actionGet();
        return response;
    }

    public SearchResponse minimumShouldMatch(List<String> terms, String field, int percentage) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\"bool\":{\"should\":[");
        for (int i = 0; i < terms.size(); ++i) {
            String term = terms.get(i);
            sb.append("{\"constant_score\": {\n            \"query\": {\n              \"match\": {");
            sb.append("\"").append(field).append("\":").append("\"").append(term).append("\"");
            sb.append("}\n            }\n          }\n        }");
            if (i == terms.size() - 1) continue;
            sb.append(",");
        }
        sb.append("],\"minimum_should_match\":");
        sb.append("\"").append(percentage).append("%").append("\"").append("}}");
        return this.submitQuery(sb.toString());
    }

    public SearchResponse minimumShouldMatch(String string, String field, int percentage, String analyzer) {
        List<String> terms = this.analyzeString(string, analyzer);
        return this.minimumShouldMatch(terms, field, percentage);
    }

    public SearchResponse minimumShouldMatch(List<String> terms, String field, int percentage, int size, String docFilter) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (String term : terms) {
            queryBuilder.should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)term)));
        }
        queryBuilder.minimumShouldMatch("" + percentage + "%");
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(size).setTrackScores(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.wrapperQuery((String)docFilter)).must((QueryBuilder)queryBuilder)).execute().actionGet();
        return response;
    }

    public List<String> termFilter(String field, String term, String filterQuery, int size) throws Exception {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        TermQueryBuilder termFilterBuilder = new TermQueryBuilder(field, term);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(size).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)termFilterBuilder)).filter((QueryBuilder)QueryBuilders.wrapperQuery((String)filterQuery)))).execute().actionGet();
        ArrayList<String> list = new ArrayList<String>(response.getHits().getHits().length);
        for (SearchHit searchHit : response.getHits()) {
            list.add(searchHit.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time spent on termFilter() for " + term + " = " + stopWatch + " There are " + list.size() + " matched docs");
        }
        return list;
    }

    public Set<String> listAllFields() throws Exception {
        GetMappingsResponse response = (GetMappingsResponse)this.client.admin().indices().prepareGetMappings(new String[]{this.indexName}).execute().actionGet();
        MappingMetaData mappingMetaData = (MappingMetaData)((ImmutableOpenMap)response.getMappings().get((Object)this.indexName)).get((Object)this.documentType);
        Map map = (Map)mappingMetaData.getSourceAsMap().get("properties");
        HashSet<String> fields = new HashSet<String>();
        for (Object field : map.keySet()) {
            fields.add(field.toString());
        }
        return fields;
    }

    public String getFieldType(String field) {
        GetFieldMappingsResponse response = (GetFieldMappingsResponse)this.client.admin().indices().prepareGetFieldMappings(new String[]{this.indexName}).setTypes(new String[]{this.documentType}).setFields(new String[]{field}).execute().actionGet();
        Map map = (Map)((GetFieldMappingsResponse.FieldMappingMetaData)((Map)((Map)response.mappings().get(this.indexName)).get(this.documentType)).get(field)).sourceAsMap().get(field);
        return map.get("type").toString();
    }

    public List<String> getStringListField(String id, String field) {
        Object object = this.getField(id, field);
        if (object == null) {
            return new ArrayList<String>();
        }
        return this.getListField(id, field).stream().map(obj -> obj.toString()).collect(Collectors.toList());
    }

    public List<Float> getFloatListField(String id, String field) {
        return this.getListField(id, field).stream().map(object -> Float.valueOf(Float.parseFloat(object.toString()))).collect(Collectors.toList());
    }

    public String getStringField(String id, String field) {
        Object object = this.getField(id, field);
        if (object == null) {
            return STRING_MISSING_VALUE;
        }
        return object.toString();
    }

    public int getIntField(String id, String field) {
        return Integer.parseInt(this.getField(id, field).toString());
    }

    public float getFloatField(String id, String field) {
        Object object = this.getField(id, field);
        if (object == null) {
            return Float.NaN;
        }
        return Float.parseFloat(object.toString());
    }

    public List<String> docsWithFieldMissing(String field, String[] ids) {
        ArrayList<String> docs = new ArrayList<String>();
        for (String id : ids) {
            Object object = this.getField(id, field);
            if (object != null) continue;
            docs.add(id);
        }
        return docs;
    }

    public Set<TermStat> getTermStats(String id) throws IOException {
        return this.getTermStats(this.bodyField, id);
    }

    public Set<TermStat> getTermStats(String field, String id) throws IOException {
        StopWatch stopWatch = null;
        if (logger.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        TermVectorsResponse response = (TermVectorsResponse)this.client.prepareTermVector(this.indexName, this.documentType, id).setOffsets(false).setPositions(false).setFieldStatistics(false).setTermStatistics(true).setSelectedFields(new String[]{field}).execute().actionGet();
        Terms terms = response.getFields().terms(field);
        HashSet<TermStat> set = new HashSet<TermStat>();
        if (terms == null) {
            return set;
        }
        TermsEnum iterator = terms.iterator();
        PostingsEnum postings = null;
        int i = 0;
        while ((long)i < terms.size()) {
            String term = iterator.next().utf8ToString();
            postings = iterator.postings(postings);
            int tf = postings.freq();
            int df = iterator.docFreq();
            ClassicSimilarity defaultSimilarity = new ClassicSimilarity();
            float tfidf = (float)tf * defaultSimilarity.idf((long)df, (long)this.numDocs);
            TermStat termStat = new TermStat(term);
            termStat.setTf(tf).setDf(df).setTfidf(tfidf);
            set.add(termStat);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time spent on getNgramInfos for " + id + " = " + stopWatch);
        }
        return set;
    }

    public int getDocLength(String id) {
        return this.getTermVector(id).keySet().size();
    }

    public Map<Integer, String> getTermVector(String id) {
        Map termVector = null;
        try {
            termVector = (Map)this.termVectorCache.get((Object)id);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return termVector;
    }

    public Map<Integer, String> getTermVectorFromIndex(String field, String id) {
        Map<Integer, String> map = null;
        try {
            map = this.getTermVectorWithException(field, id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map<Integer, String> getTermVectorFromIndex(String id) {
        return this.getTermVectorFromIndex(this.bodyField, id);
    }

    private Map<Integer, String> getTermVectorWithException(String field, String id) throws IOException {
        TermVectorsResponse response = (TermVectorsResponse)this.client.prepareTermVector(this.indexName, this.documentType, id).setOffsets(false).setPositions(true).setFieldStatistics(false).setTermStatistics(false).setSelectedFields(new String[]{field}).execute().actionGet();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Terms terms = response.getFields().terms(field);
        if (terms == null) {
            return map;
        }
        TermsEnum iterator = terms.iterator();
        PostingsEnum postings = null;
        BytesRef termBytes = null;
        while ((termBytes = iterator.next()) != null) {
            String term = termBytes.utf8ToString();
            postings = iterator.postings(postings, 120);
            postings.nextDoc();
            int tf = postings.freq();
            for (int i = 0; i < tf; ++i) {
                int pos = postings.nextPosition();
                map.put(pos, term);
            }
        }
        return map;
    }

    @Override
    public void close() {
        this.client.close();
        if (this.clientType.equals("node")) {
            try {
                if (this.node != null) {
                    this.node.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected int fetchNumDocs() throws Exception {
        return (int)((SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFetchSource(false).execute().actionGet()).getHits().getTotalHits();
    }

    public boolean hasField(String id, String field) {
        return this.getField(id, field) != null;
    }

    public Object getField(String id, String field) {
        GetResponse response = (GetResponse)this.client.prepareGet(this.indexName, this.documentType, id).setStoredFields(new String[]{field}).execute().actionGet();
        if (response == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("no response from document " + id + " when fetching field " + field + "!");
            }
            return null;
        }
        if (response.getField(field) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("document " + id + " has no field " + field + "!");
            }
            return null;
        }
        return response.getField(field).getValue();
    }

    public List<Object> getListField(String id, String field) {
        GetResponse response = (GetResponse)this.client.prepareGet(this.indexName, this.documentType, id).setStoredFields(new String[]{field}).execute().actionGet();
        if (response == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("no response from document " + id + " when fetching field " + field + "!");
            }
            return new ArrayList<Object>();
        }
        if (response.getField(field) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("document " + id + " has no field " + field + "!");
            }
            return new ArrayList<Object>();
        }
        return response.getField(field).getValues();
    }

    public SearchResponse matchPhrase(String field, String phrase, int slop) {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)phrase).slop(slop).analyzer("whitespace")).execute().actionGet();
        return response;
    }

    public SearchResponse matchPhrase(String field, String phrase, String[] ids, int slop) {
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(ids.length).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)phrase).slop(slop).analyzer("whitespace")).filter((QueryBuilder)idsFilterBuilder)).execute().actionGet();
        return response;
    }

    public SearchResponse spanNear(Ngram ngram) {
        if (ngram.getTerms().length == 0) {
            throw new IllegalStateException("No terms found for span");
        }
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[i]));
        }
        queryBuilder.inOrder(inOrder);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)(ngram.getTerms().length > 1 ? queryBuilder : QueryBuilders.matchPhraseQuery((String)field, (Object)ngram.getTerms()[0]).slop(slop))).execute().actionGet();
        return response;
    }

    public Collection<Terms.Bucket> termAggregation(String field) {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(0).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(field)).size(Integer.MAX_VALUE)).execute().actionGet();
        org.elasticsearch.search.aggregations.bucket.terms.Terms terms = (org.elasticsearch.search.aggregations.bucket.terms.Terms)response.getAggregations().get("agg");
        List buckets = terms.getBuckets();
        return buckets;
    }

    public Collection<Terms.Bucket> termAggregation(String field, String[] ids) {
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(0).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)idsFilterBuilder).must((QueryBuilder)QueryBuilders.matchAllQuery())).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(field)).size(Integer.MAX_VALUE)).execute().actionGet();
        org.elasticsearch.search.aggregations.bucket.terms.Terms terms = (org.elasticsearch.search.aggregations.bucket.terms.Terms)response.getAggregations().get("agg");
        List buckets = terms.getBuckets();
        return buckets;
    }

    public long count(Ngram ngram) {
        if (ngram.getTerms().length == 0) {
            throw new IllegalArgumentException("No terms for span");
        }
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[1]));
        }
        queryBuilder.inOrder(inOrder);
        long hits = ((SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setQuery((QueryBuilder)queryBuilder).execute().actionGet()).getHits().getTotalHits();
        return hits;
    }

    public long count(Ngram ngram, String[] ids) {
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[1]));
        }
        queryBuilder.inOrder(inOrder);
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        long hits = ((SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setQuery((QueryBuilder)queryBuilder).execute().actionGet()).getHits().getTotalHits();
        return hits;
    }

    public SearchResponse spanNear(Ngram ngram, int size) {
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[1]));
        }
        queryBuilder.inOrder(inOrder);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(size).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)(ngram.getTerms().length > 1 ? queryBuilder : QueryBuilders.matchPhraseQuery((String)field, (Object)ngram.getTerms()[0]).slop(slop))).execute().actionGet();
        System.out.println(response.getHits().getTotalHits());
        return response;
    }

    public SearchResponse spanNear(Ngram ngram, String filterQuery, int size) {
        if (ngram.getTerms().length == 0) {
            throw new IllegalArgumentException("no terms for span");
        }
        String field = ngram.getField();
        int slop = ngram.getSlop();
        boolean inOrder = ngram.isInOrder();
        SpanNearQueryBuilder queryBuilder = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[0]), (int)slop);
        for (int i = 1; i < ngram.getTerms().length; ++i) {
            queryBuilder.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field, ngram.getTerms()[i]));
        }
        queryBuilder.inOrder(inOrder);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(size).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.wrapperQuery((String)filterQuery)).must((QueryBuilder)(ngram.getTerms().length > 1 ? queryBuilder : QueryBuilders.matchPhraseQuery((String)field, (Object)ngram.getTerms()[0]).slop(slop)))).execute().actionGet();
        return response;
    }

    public SearchResponse spanNearFrequency(Ngram ngram, String filterQuery, int size) {
        if (ngram.getTerms().length == 0) {
            throw new IllegalArgumentException("No term for span");
        }
        int slop = ngram.getSlop();
        PhraseCountQueryBuilder queryBuilder = new PhraseCountQueryBuilder(ngram.getField(), slop, false, ngram.getTerms());
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(size).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter((QueryBuilder)QueryBuilders.wrapperQuery((String)filterQuery))).execute().actionGet();
        return response;
    }

    public SearchResponse spanNot(SpanNotNgram ngram, String[] ids) {
        Ngram include = ngram.getInclude();
        String field1 = include.getField();
        int slop1 = include.getSlop();
        boolean inOrder1 = include.isInOrder();
        SpanNearQueryBuilder queryBuilder1 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[0]), (int)slop1);
        for (int i = 1; i < include.getTerms().length; ++i) {
            queryBuilder1.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[i]));
        }
        queryBuilder1.inOrder(inOrder1);
        Ngram exclude = ngram.getExclude();
        String field2 = exclude.getField();
        int slop2 = exclude.getSlop();
        boolean inOrder2 = exclude.isInOrder();
        SpanNearQueryBuilder queryBuilder2 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[0]), (int)slop2);
        for (int i = 1; i < exclude.getTerms().length; ++i) {
            queryBuilder2.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[i]));
        }
        queryBuilder2.inOrder(inOrder2);
        int pre = ngram.getPre();
        int post = ngram.getPost();
        SpanNotQueryBuilder spanNotQueryBuilder = new SpanNotQueryBuilder((SpanQueryBuilder)queryBuilder1, (SpanQueryBuilder)queryBuilder2);
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(ids.length).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)idsFilterBuilder).should((QueryBuilder)spanNotQueryBuilder)).execute().actionGet();
        return response;
    }

    public SearchResponse spanNot(SpanNotNgram ngram) {
        Ngram include = ngram.getInclude();
        String field1 = include.getField();
        int slop1 = include.getSlop();
        boolean inOrder1 = include.isInOrder();
        SpanNearQueryBuilder queryBuilder1 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[0]), (int)slop1);
        for (int i = 1; i < include.getTerms().length; ++i) {
            queryBuilder1.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field1, include.getTerms()[i]));
        }
        queryBuilder1.inOrder(inOrder1);
        Ngram exclude = ngram.getExclude();
        String field2 = exclude.getField();
        int slop2 = exclude.getSlop();
        boolean inOrder2 = exclude.isInOrder();
        SpanNearQueryBuilder queryBuilder2 = QueryBuilders.spanNearQuery((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[0]), (int)slop2);
        for (int i = 1; i < exclude.getTerms().length; ++i) {
            queryBuilder2.addClause((SpanQueryBuilder)new SpanTermQueryBuilder(field2, exclude.getTerms()[i]));
        }
        queryBuilder2.inOrder(inOrder2);
        int pre = ngram.getPre();
        int post = ngram.getPost();
        SpanNotQueryBuilder spanNotQueryBuilder = new SpanNotQueryBuilder((SpanQueryBuilder)queryBuilder1, (SpanQueryBuilder)queryBuilder2);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)spanNotQueryBuilder).execute().actionGet();
        return response;
    }

    public SearchResponse match(String field, String phrase, Operator operator) {
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(this.numDocs).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)phrase).operator(operator).analyzer("whitespace")).execute().actionGet();
        return response;
    }

    public SearchResponse match(String field, String phrase, String[] ids, Operator operator) {
        IdsQueryBuilder idsFilterBuilder = new IdsQueryBuilder(new String[]{this.documentType});
        idsFilterBuilder.addIds(ids);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexName}).setSize(ids.length).setTrackScores(false).setFetchSource(false).setExplain(false).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)phrase).operator(operator).analyzer("whitespace")).must((QueryBuilder)idsFilterBuilder)).execute().actionGet();
        return response;
    }

    public long phraseDF(String field, String phrase, int slop) {
        SearchResponse response = this.matchPhrase(field, phrase, slop);
        return response.getHits().getTotalHits();
    }

    public long DF(String field, String phrase, Operator operator) {
        SearchResponse response = this.match(field, phrase, operator);
        return response.getHits().getTotalHits();
    }

    public Ngram analyze(String text, String analyzer) {
        List tokens = ((AnalyzeResponse)this.client.admin().indices().prepareAnalyze(this.indexName, text).setAnalyzer(analyzer).get()).getTokens();
        Ngram ngram = new Ngram();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            AnalyzeResponse.AnalyzeToken token = (AnalyzeResponse.AnalyzeToken)tokens.get(i);
            sb.append(token.getTerm());
            if (i == tokens.size() - 1) continue;
            sb.append(" ");
        }
        ngram.setNgram(sb.toString());
        return ngram;
    }

    public List<String> analyzeString(String text, String analyzer) {
        List tokens = ((AnalyzeResponse)this.client.admin().indices().prepareAnalyze(this.indexName, text).setAnalyzer(analyzer).get()).getTokens();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            AnalyzeResponse.AnalyzeToken token = (AnalyzeResponse.AnalyzeToken)tokens.get(i);
            list.add(token.getTerm());
        }
        return list;
    }

    public static class Builder {
        private String indexName = "unknown_index";
        private String documentType = "document";
        private String clientType = "transport";
        private String clusterName = "elasticsearch";
        private String bodyField = "body";
        private List<String> hosts = new ArrayList<String>();
        private List<Integer> ports = new ArrayList<Integer>();
        private int termVectorCacheSize = 10000;

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setDocumentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public Builder setClientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder addHostAndPort(String host, int port) {
            this.hosts.add(host);
            this.ports.add(port);
            return this;
        }

        public Builder addHostsAndPorts(String[] hosts, String[] ports) {
            for (int i = 0; i < hosts.length; ++i) {
                this.addHostAndPort(hosts[i], Integer.parseInt(ports[i]));
            }
            return this;
        }

        public Builder setBodyField(String bodyField) {
            this.bodyField = bodyField;
            return this;
        }

        public Builder setTermVectorCacheSize(int termVectorCacheSize) {
            this.termVectorCacheSize = termVectorCacheSize;
            return this;
        }

        public ESIndex build() throws Exception {
            boolean legal;
            boolean bl = legal = this.clientType.equals("node") || this.clientType.equals("transport");
            if (!legal) {
                throw new IllegalArgumentException("clientType = node or transport");
            }
            final ESIndex esIndex = new ESIndex();
            esIndex.indexName = this.indexName;
            esIndex.documentType = this.documentType;
            esIndex.clientType = this.clientType;
            esIndex.clusterName = this.clusterName;
            esIndex.bodyField = this.bodyField;
            if (this.clientType.equals("node")) {
                Node node;
                Settings settings = Settings.builder().put("cluster.name", this.clusterName).put("node.data", false).build();
                esIndex.node = node = new Node(settings);
                esIndex.client = node.client();
            } else {
                Settings settings = Settings.builder().put("cluster.name", this.clusterName).build();
                esIndex.client = new PreBuiltTransportClient(settings, new Class[0]);
                for (int i = 0; i < this.hosts.size(); ++i) {
                    ((TransportClient)esIndex.client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.hosts.get(i), (int)this.ports.get(i))));
                }
            }
            esIndex.numDocs = esIndex.fetchNumDocs();
            esIndex.termVectorCache = CacheBuilder.newBuilder().maximumSize((long)this.termVectorCacheSize).build((CacheLoader)new CacheLoader<String, Map<Integer, String>>(){

                public Map<Integer, String> load(String id) throws Exception {
                    return esIndex.getTermVectorFromIndex(id);
                }
            });
            return esIndex;
        }
    }
}

