/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.configuration.Config;
import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.DataSetType;
import edu.neu.ccs.pyramid.dataset.DenseClfDataSet;
import edu.neu.ccs.pyramid.dataset.DenseMLClfDataSet;
import edu.neu.ccs.pyramid.dataset.DenseRegDataSet;
import edu.neu.ccs.pyramid.dataset.IdTranslator;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.dataset.RegDataSet;
import edu.neu.ccs.pyramid.dataset.SequentialSparseMLClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseMLClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseRegDataSet;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.mahout.math.Vector;

public class TRECFormat {
    private static final String TREC_MATRIX_FILE_NAME = "feature_matrix.txt";
    private static final String TREC_CONFIG_FILE_NAME = "config.txt";
    private static final String TREC_CONFIG_NUM_DATA_POINTS = "numDataPoints";
    private static final String TREC_CONFIG_NUM_FEATURES = "numFeatures";
    private static final String TREC_CONFIG_NUM_CLASSES = "numClasses";
    private static final String TREC_CONFIG_MISSING_VALUE = "missingValue";
    private static final String TREC_FEATURE_LIST_FILE_NAME = "feature_list.ser";
    private static final String TREC_FEATURE_LIST_TEXT_FILE_NAME = "feature_list.txt";
    private static final String TREC_ID_TRANSLATOR_FILE_NAME = "id_translator.ser";
    private static final String TREC_ID_TRANSLATOR_TEXT_FILE_NAME = "id_translator.txt";
    private static final String TREC_LABEL_TRANSLATOR_FILE_NAME = "label_translator.ser";
    private static final String TREC_LABEL_TRANSLATOR_TEXT_FILE_NAME = "label_translator.txt";

    public static void save(DataSet dataSet, String trecFile) {
        if (dataSet instanceof ClfDataSet) {
            TRECFormat.save((ClfDataSet)dataSet, trecFile);
        } else if (dataSet instanceof RegDataSet) {
            TRECFormat.save((RegDataSet)dataSet, trecFile);
        } else if (dataSet instanceof MultiLabelClfDataSet) {
            TRECFormat.save((MultiLabelClfDataSet)dataSet, trecFile);
        }
    }

    public static void save(ClfDataSet dataSet, String trecFile) {
        TRECFormat.save(dataSet, new File(trecFile));
    }

    public static void save(RegDataSet dataSet, String trecFile) {
        TRECFormat.save(dataSet, new File(trecFile));
    }

    public static void save(MultiLabelClfDataSet dataSet, String trecFile) {
        TRECFormat.save(dataSet, new File(trecFile));
    }

    public static void save(ClfDataSet dataSet, File trecFile) {
        if (!trecFile.exists()) {
            trecFile.mkdirs();
        }
        TRECFormat.writeMatrixFile(dataSet, trecFile);
        TRECFormat.writeConfigFile(dataSet, trecFile);
        TRECFormat.writeFeatureList(dataSet, trecFile);
        TRECFormat.writeIdTranslator(dataSet, trecFile);
        TRECFormat.writeLabelTranslator(dataSet, trecFile);
    }

    public static void save(MultiLabelClfDataSet dataSet, File trecFile) {
        if (!trecFile.exists()) {
            trecFile.mkdirs();
        }
        TRECFormat.writeMatrixFile(dataSet, trecFile);
        TRECFormat.writeConfigFile(dataSet, trecFile);
        TRECFormat.writeFeatureList(dataSet, trecFile);
        TRECFormat.writeIdTranslator(dataSet, trecFile);
        TRECFormat.writeLabelTranslator(dataSet, trecFile);
    }

    public static void save(RegDataSet dataSet, File trecFile) {
        if (!trecFile.exists()) {
            trecFile.mkdirs();
        }
        TRECFormat.writeMatrixFile(dataSet, trecFile);
        TRECFormat.writeConfigFile(dataSet, trecFile);
        TRECFormat.writeFeatureList(dataSet, trecFile);
        TRECFormat.writeIdTranslator(dataSet, trecFile);
    }

    public static ClfDataSet loadClfDataSet(String trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        return TRECFormat.loadClfDataSet(new File(trecFile), dataSetType, loadSettings);
    }

    public static RegDataSet loadRegDataSet(String trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        return TRECFormat.loadRegDataSet(new File(trecFile), dataSetType, loadSettings);
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSet(String trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        return TRECFormat.loadMultiLabelClfDataSet(new File(trecFile), dataSetType, loadSettings);
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSetAutoSparseRandom(String trecFile) throws IOException, ClassNotFoundException {
        return TRECFormat.loadMultiLabelClfDataSetAutoSparseRandom(new File(trecFile));
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSetAutoSparseSequential(String trecFile) throws IOException, ClassNotFoundException {
        return TRECFormat.loadMultiLabelClfDataSetAutoSparseSequential(new File(trecFile));
    }

    public static ClfDataSet loadClfDataSet(File trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        boolean legalArg;
        boolean bl = legalArg = dataSetType == DataSetType.CLF_DENSE || dataSetType == DataSetType.CLF_SPARSE;
        if (!legalArg) {
            throw new IllegalArgumentException("illegal data set type");
        }
        int numDataPoints = TRECFormat.parseNumDataPoints(trecFile);
        int numFeatures = TRECFormat.parseNumFeaturess(trecFile);
        int numClasses = TRECFormat.parseNumClasses(trecFile);
        boolean missingValue = TRECFormat.parseMissingValue(trecFile);
        AbstractDataSet dataSet = null;
        if (dataSetType == DataSetType.CLF_DENSE) {
            dataSet = new DenseClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        if (dataSetType == DataSetType.CLF_SPARSE) {
            dataSet = new SparseClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        TRECFormat.fillClfDataSet(dataSet, trecFile);
        if (loadSettings) {
            TRECFormat.loadFeatureList(dataSet, trecFile);
            TRECFormat.loadIdTranslator(dataSet, trecFile);
            TRECFormat.loadLabelTranslator(dataSet, trecFile);
        }
        return dataSet;
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSet(File trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        boolean legalArg;
        boolean bl = legalArg = dataSetType == DataSetType.ML_CLF_DENSE || dataSetType == DataSetType.ML_CLF_SPARSE || dataSetType == DataSetType.ML_CLF_SEQ_SPARSE;
        if (!legalArg) {
            throw new IllegalArgumentException("illegal data set type");
        }
        int numDataPoints = TRECFormat.parseNumDataPoints(trecFile);
        int numFeatures = TRECFormat.parseNumFeaturess(trecFile);
        int numClasses = TRECFormat.parseNumClasses(trecFile);
        boolean missingValue = TRECFormat.parseMissingValue(trecFile);
        AbstractDataSet dataSet = null;
        if (dataSetType == DataSetType.ML_CLF_DENSE) {
            dataSet = new DenseMLClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        if (dataSetType == DataSetType.ML_CLF_SPARSE) {
            dataSet = new SparseMLClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        if (dataSetType == DataSetType.ML_CLF_SEQ_SPARSE) {
            dataSet = new SequentialSparseMLClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        TRECFormat.fillMultiLabelClfDataSet(dataSet, trecFile);
        if (loadSettings) {
            TRECFormat.loadFeatureList(dataSet, trecFile);
            TRECFormat.loadIdTranslator(dataSet, trecFile);
            TRECFormat.loadLabelTranslator(dataSet, trecFile);
        }
        return dataSet;
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSetAutoSparseRandom(File trecFile) throws IOException, ClassNotFoundException {
        boolean dense = TRECFormat.isDense(trecFile);
        if (dense) {
            return TRECFormat.loadMultiLabelClfDataSet(trecFile, DataSetType.ML_CLF_DENSE, true);
        }
        return TRECFormat.loadMultiLabelClfDataSet(trecFile, DataSetType.ML_CLF_SPARSE, true);
    }

    public static MultiLabelClfDataSet loadMultiLabelClfDataSetAutoSparseSequential(File trecFile) throws IOException, ClassNotFoundException {
        boolean dense = TRECFormat.isDense(trecFile);
        if (dense) {
            return TRECFormat.loadMultiLabelClfDataSet(trecFile, DataSetType.ML_CLF_DENSE, true);
        }
        return TRECFormat.loadMultiLabelClfDataSet(trecFile, DataSetType.ML_CLF_SEQ_SPARSE, true);
    }

    public static RegDataSet loadRegDataSet(File trecFile, DataSetType dataSetType, boolean loadSettings) throws IOException, ClassNotFoundException {
        boolean legalArg;
        boolean bl = legalArg = dataSetType == DataSetType.REG_DENSE || dataSetType == DataSetType.REG_SPARSE;
        if (!legalArg) {
            throw new IllegalArgumentException("illegal data set type");
        }
        int numDataPoints = TRECFormat.parseNumDataPoints(trecFile);
        int numFeatures = TRECFormat.parseNumFeaturess(trecFile);
        boolean missingValue = TRECFormat.parseMissingValue(trecFile);
        AbstractDataSet dataSet = null;
        if (dataSetType == DataSetType.REG_DENSE) {
            dataSet = new DenseRegDataSet(numDataPoints, numFeatures, missingValue);
        }
        if (dataSetType == DataSetType.REG_SPARSE) {
            dataSet = new SparseRegDataSet(numDataPoints, numFeatures, missingValue);
        }
        TRECFormat.fillRegDataSet(dataSet, trecFile);
        if (loadSettings) {
            TRECFormat.loadFeatureList(dataSet, trecFile);
            TRECFormat.loadIdTranslator(dataSet, trecFile);
        }
        return dataSet;
    }

    public static List<String> parseComments(File trecFile) {
        ArrayList<String> comments = new ArrayList<String>();
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line = null;
            while ((line = br.readLine()) != null) {
                int startPos = line.lastIndexOf("#") + 1;
                int endPos = line.length();
                String comment = line.substring(startPos, endPos);
                System.out.println(comment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return comments;
    }

    static int parseNumDataPoints(File trecFile) throws IOException {
        int numDataPoints;
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            Config config = new Config(configFile);
            numDataPoints = config.getInt(TREC_CONFIG_NUM_DATA_POINTS);
        }
        return numDataPoints;
    }

    static int parseNumFeaturess(File trecFile) throws IOException {
        int numFeatures;
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            Config config = new Config(configFile);
            numFeatures = config.getInt(TREC_CONFIG_NUM_FEATURES);
        }
        return numFeatures;
    }

    static int parseNumClasses(File trecFile) throws IOException {
        int numClasses;
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            Config config = new Config(configFile);
            numClasses = config.getInt(TREC_CONFIG_NUM_CLASSES);
        }
        return numClasses;
    }

    static boolean parseMissingValue(File trecFile) throws IOException {
        boolean missingValue;
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            Config config = new Config(configFile);
            missingValue = config.getBoolean(TREC_CONFIG_MISSING_VALUE);
        }
        return missingValue;
    }

    static boolean isDense(File trecFile) throws IOException {
        double density;
        int numFeatures = TRECFormat.parseNumFeaturess(trecFile);
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        int data = 0;
        double nonZeros = 0.0;
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line = null;
            while ((line = br.readLine()) != null) {
                String pair;
                String[] lineSplit = line.split("\\s+");
                for (int i = 1; i < lineSplit.length && !(pair = lineSplit[i]).startsWith("#"); ++i) {
                    String[] pairSplit = pair.split(":");
                    double featureValue = Double.parseDouble(pairSplit[1]);
                    if (featureValue == 0.0) continue;
                    nonZeros += 1.0;
                }
                if (++data != 100) continue;
                break;
            }
        }
        return (density = nonZeros / (double)(numFeatures * data)) > 0.3;
    }

    private static void fillClfDataSet(ClfDataSet dataSet, File trecFile) throws IOException {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line = null;
            int dataIndex = 0;
            while ((line = br.readLine()) != null) {
                String pair;
                String[] lineSplit = line.split("\\s+");
                int label = Integer.parseInt(lineSplit[0]);
                dataSet.setLabel(dataIndex, label);
                for (int i = 1; i < lineSplit.length && !(pair = lineSplit[i]).startsWith("#"); ++i) {
                    String[] pairSplit = pair.split(":");
                    int featureIndex = Integer.parseInt(pairSplit[0]);
                    double featureValue = Double.parseDouble(pairSplit[1]);
                    dataSet.setFeatureValue(dataIndex, featureIndex, featureValue);
                }
                ++dataIndex;
            }
        }
    }

    private static void fillMultiLabelClfDataSet(MultiLabelClfDataSet dataSet, File trecFile) throws IOException {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line = null;
            int dataIndex = 0;
            while ((line = br.readLine()) != null) {
                String pair;
                String[] lineSplit = line.split("\\s+");
                if (lineSplit.length >= 1) {
                    String[] multiLabelSplit;
                    String multiLabelString = null;
                    try {
                        multiLabelString = lineSplit[0];
                    }
                    catch (Exception e) {
                        System.out.println("load data error happens");
                        System.out.println("line number: " + dataIndex);
                        System.out.println("line: " + line);
                    }
                    for (String label : multiLabelSplit = multiLabelString.split(Pattern.quote(","))) {
                        if (label.equals("")) continue;
                        dataSet.addLabel(dataIndex, Integer.parseInt(label));
                    }
                }
                for (int i = 1; i < lineSplit.length && !(pair = lineSplit[i]).startsWith("#"); ++i) {
                    String[] pairSplit = pair.split(":");
                    int featureIndex = Integer.parseInt(pairSplit[0]);
                    double featureValue = Double.parseDouble(pairSplit[1]);
                    dataSet.setFeatureValue(dataIndex, featureIndex, featureValue);
                }
                ++dataIndex;
            }
        }
    }

    private static void fillRegDataSet(RegDataSet dataSet, File trecFile) throws IOException {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line = null;
            int dataIndex = 0;
            while ((line = br.readLine()) != null) {
                String pair;
                String[] lineSplit = line.split("\\s+");
                double label = Double.parseDouble(lineSplit[0]);
                dataSet.setLabel(dataIndex, label);
                for (int i = 1; i < lineSplit.length && !(pair = lineSplit[i]).startsWith("#"); ++i) {
                    String[] pairSplit = pair.split(":");
                    int featureIndex = Integer.parseInt(pairSplit[0]);
                    double featureValue = Double.parseDouble(pairSplit[1]);
                    dataSet.setFeatureValue(dataIndex, featureIndex, featureValue);
                }
                ++dataIndex;
            }
        }
    }

    private static void writeConfigFile(ClfDataSet dataSet, File trecFile) {
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        Config config = new Config();
        config.setInt(TREC_CONFIG_NUM_DATA_POINTS, dataSet.getNumDataPoints());
        config.setInt(TREC_CONFIG_NUM_FEATURES, dataSet.getNumFeatures());
        config.setInt(TREC_CONFIG_NUM_CLASSES, dataSet.getNumClasses());
        config.setBoolean(TREC_CONFIG_MISSING_VALUE, dataSet.hasMissingValue());
        try {
            config.store(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeConfigFile(MultiLabelClfDataSet dataSet, File trecFile) {
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        Config config = new Config();
        config.setInt(TREC_CONFIG_NUM_DATA_POINTS, dataSet.getNumDataPoints());
        config.setInt(TREC_CONFIG_NUM_FEATURES, dataSet.getNumFeatures());
        config.setInt(TREC_CONFIG_NUM_CLASSES, dataSet.getNumClasses());
        config.setBoolean(TREC_CONFIG_MISSING_VALUE, dataSet.hasMissingValue());
        try {
            config.store(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeConfigFile(RegDataSet dataSet, File trecFile) {
        File configFile = new File(trecFile, TREC_CONFIG_FILE_NAME);
        Config config = new Config();
        config.setInt(TREC_CONFIG_NUM_DATA_POINTS, dataSet.getNumDataPoints());
        config.setInt(TREC_CONFIG_NUM_FEATURES, dataSet.getNumFeatures());
        config.setBoolean(TREC_CONFIG_MISSING_VALUE, dataSet.hasMissingValue());
        try {
            config.store(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeMatrixFile(ClfDataSet dataSet, File trecFile) {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        int numDataPoints = dataSet.getNumDataPoints();
        int[] labels = dataSet.getLabels();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(matrixFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                int label = labels[i];
                bw.write(label + " ");
                Vector vector = dataSet.getRow(i);
                ArrayList<Pair<Integer, Double>> pairs = new ArrayList<Pair<Integer, Double>>();
                for (Vector.Element element : vector.nonZeroes()) {
                    Pair<Integer, Double> pair = new Pair<Integer, Double>(element.index(), element.get());
                    pairs.add(pair);
                }
                Comparator<Pair> comparator = Comparator.comparing(Pair::getFirst);
                List sorted = pairs.stream().sorted(comparator).collect(Collectors.toList());
                for (Pair pair : sorted) {
                    bw.write(pair.getFirst() + ":" + pair.getSecond() + " ");
                }
                bw.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeMatrixFile(RegDataSet dataSet, File trecFile) {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        int numDataPoints = dataSet.getNumDataPoints();
        double[] labels = dataSet.getLabels();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(matrixFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                double label = labels[i];
                bw.write(label + " ");
                Vector vector = dataSet.getRow(i);
                ArrayList<Pair<Integer, Double>> pairs = new ArrayList<Pair<Integer, Double>>();
                for (Vector.Element element : vector.nonZeroes()) {
                    Pair<Integer, Double> pair = new Pair<Integer, Double>(element.index(), element.get());
                    pairs.add(pair);
                }
                Comparator<Pair> comparator = Comparator.comparing(Pair::getFirst);
                List sorted = pairs.stream().sorted(comparator).collect(Collectors.toList());
                for (Pair pair : sorted) {
                    bw.write(pair.getFirst() + ":" + pair.getSecond() + " ");
                }
                bw.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeMatrixFile(MultiLabelClfDataSet dataSet, File trecFile) {
        File matrixFile = new File(trecFile, TREC_MATRIX_FILE_NAME);
        int numDataPoints = dataSet.getNumDataPoints();
        MultiLabel[] multiLabels = dataSet.getMultiLabels();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(matrixFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                MultiLabel multiLabel = multiLabels[i];
                List labels = multiLabel.getMatchedLabels().stream().sorted().collect(Collectors.toList());
                for (int l = 0; l < labels.size(); ++l) {
                    bw.write(((Integer)labels.get(l)).toString());
                    if (l == labels.size() - 1) continue;
                    bw.write(",");
                }
                bw.write(" ");
                Vector vector = dataSet.getRow(i);
                ArrayList<Pair<Integer, Double>> pairs = new ArrayList<Pair<Integer, Double>>();
                for (Vector.Element element : vector.nonZeroes()) {
                    Pair<Integer, Double> pair = new Pair<Integer, Double>(element.index(), element.get());
                    pairs.add(pair);
                }
                Comparator<Pair> comparator = Comparator.comparing(Pair::getFirst);
                List sorted = pairs.stream().sorted(comparator).collect(Collectors.toList());
                for (Pair pair : sorted) {
                    bw.write(pair.getFirst() + ":" + pair.getSecond() + " ");
                }
                bw.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeFeatureList(DataSet dataSet, File trecFile) {
        File file = new File(trecFile, TREC_FEATURE_LIST_FILE_NAME);
        FeatureList featureList = dataSet.getFeatureList();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            Object object = null;
            try (ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(bufferedOutputStream);){
                objectOutputStream2.writeObject(featureList);
            }
            catch (Throwable objectOutputStream2) {
                object = objectOutputStream2;
                throw objectOutputStream2;
            }
            finally {
                if (bufferedOutputStream != null) {
                    if (object != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (Throwable objectOutputStream2) {
                            ((Throwable)object).addSuppressed(objectOutputStream2);
                        }
                    } else {
                        bufferedOutputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File txtFile = new File(trecFile, TREC_FEATURE_LIST_TEXT_FILE_NAME);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(txtFile));){
            for (Feature feature : featureList.getAll()) {
                bufferedWriter.write(feature.toString());
                bufferedWriter.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadFeatureList(DataSet dataSet, File trecFile) throws IOException, ClassNotFoundException {
        File file = new File(trecFile, TREC_FEATURE_LIST_FILE_NAME);
        if (file.exists()) {
            FeatureList featureList;
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);){
                featureList = (FeatureList)objectInputStream.readObject();
            }
            dataSet.setFeatureList(featureList);
        }
    }

    private static void writeIdTranslator(DataSet dataSet, File trecFile) {
        File file = new File(trecFile, TREC_ID_TRANSLATOR_FILE_NAME);
        IdTranslator idTranslator = dataSet.getIdTranslator();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(idTranslator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File txtFile = new File(trecFile, TREC_ID_TRANSLATOR_TEXT_FILE_NAME);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(txtFile));){
            bufferedWriter.write(idTranslator.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadIdTranslator(DataSet dataSet, File trecFile) throws IOException, ClassNotFoundException {
        File file = new File(trecFile, TREC_ID_TRANSLATOR_FILE_NAME);
        if (file.exists()) {
            IdTranslator idTranslator;
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);){
                idTranslator = (IdTranslator)objectInputStream.readObject();
            }
            dataSet.setIdTranslator(idTranslator);
        }
    }

    private static void writeLabelTranslator(ClfDataSet dataSet, File trecFile) {
        File file = new File(trecFile, TREC_LABEL_TRANSLATOR_FILE_NAME);
        LabelTranslator labelTranslator = dataSet.getLabelTranslator();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(labelTranslator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File txtFile = new File(trecFile, TREC_LABEL_TRANSLATOR_TEXT_FILE_NAME);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(txtFile));){
            bufferedWriter.write(labelTranslator.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadLabelTranslator(ClfDataSet dataSet, File trecFile) throws IOException, ClassNotFoundException {
        File file = new File(trecFile, TREC_LABEL_TRANSLATOR_FILE_NAME);
        if (file.exists()) {
            LabelTranslator labelTranslator;
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);){
                labelTranslator = (LabelTranslator)objectInputStream.readObject();
            }
            dataSet.setLabelTranslator(labelTranslator);
        }
    }

    private static void writeLabelTranslator(MultiLabelClfDataSet dataSet, File trecFile) {
        File file = new File(trecFile, TREC_LABEL_TRANSLATOR_FILE_NAME);
        LabelTranslator labelTranslator = dataSet.getLabelTranslator();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(labelTranslator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File txtFile = new File(trecFile, TREC_LABEL_TRANSLATOR_TEXT_FILE_NAME);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(txtFile));){
            bufferedWriter.write(labelTranslator.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadLabelTranslator(MultiLabelClfDataSet dataSet, File trecFile) throws IOException, ClassNotFoundException {
        File file = new File(trecFile, TREC_LABEL_TRANSLATOR_FILE_NAME);
        if (file.exists()) {
            LabelTranslator labelTranslator;
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);){
                labelTranslator = (LabelTranslator)objectInputStream.readObject();
            }
            dataSet.setLabelTranslator(labelTranslator);
        }
    }
}

