/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.DataSetType;
import edu.neu.ccs.pyramid.dataset.DenseClfDataSet;
import edu.neu.ccs.pyramid.dataset.DenseRegDataSet;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.dataset.RegDataSet;
import edu.neu.ccs.pyramid.dataset.SparseClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseRegDataSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class StandardFormat {
    public static ClfDataSet loadClfDataSet(int numClasses, String featureFile, String labelFile, String delimiter, DataSetType dataSetType, boolean missingValue) throws IOException {
        return StandardFormat.loadClfDataSet(numClasses, new File(featureFile), new File(labelFile), delimiter, dataSetType, missingValue);
    }

    public static RegDataSet loadRegDataSet(String featureFile, String labelFile, String delimiter, DataSetType dataSetType, boolean missingValue) throws IOException {
        return StandardFormat.loadRegDataSet(new File(featureFile), new File(labelFile), delimiter, dataSetType, missingValue);
    }

    public static ClfDataSet loadClfDataSet(int numClasses, File featureFile, File labelFile, String delimiter, DataSetType dataSetType, boolean missingValue) throws IOException {
        boolean legalArg;
        int[] stats = StandardFormat.parseStandard(featureFile, labelFile, delimiter);
        int numDataPoints = stats[0];
        int numFeatures = stats[1];
        AbstractDataSet dataSet = null;
        boolean bl = legalArg = dataSetType == DataSetType.CLF_DENSE || dataSetType == DataSetType.CLF_SPARSE;
        if (!legalArg) {
            throw new IllegalArgumentException("illegal data set type");
        }
        if (dataSetType == DataSetType.CLF_DENSE) {
            dataSet = new DenseClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        if (dataSetType == DataSetType.CLF_SPARSE) {
            dataSet = new SparseClfDataSet(numDataPoints, numFeatures, missingValue, numClasses);
        }
        StandardFormat.fill(dataSet, featureFile, labelFile, delimiter);
        return dataSet;
    }

    public static RegDataSet loadRegDataSet(File featureFile, File labelFile, String delimiter, DataSetType dataSetType, boolean missingValue) throws IOException {
        boolean legalArg;
        int[] stats = StandardFormat.parseStandard(featureFile, labelFile, delimiter);
        int numDataPoints = stats[0];
        int numFeatures = stats[1];
        AbstractDataSet dataSet = null;
        boolean bl = legalArg = dataSetType == DataSetType.REG_DENSE || dataSetType == DataSetType.REG_SPARSE;
        if (!legalArg) {
            throw new IllegalArgumentException("illegal data set type");
        }
        if (dataSetType == DataSetType.REG_DENSE) {
            dataSet = new DenseRegDataSet(numDataPoints, numFeatures, missingValue);
        }
        if (dataSetType == DataSetType.REG_SPARSE) {
            dataSet = new SparseRegDataSet(numDataPoints, numFeatures, missingValue);
        }
        StandardFormat.fill(dataSet, featureFile, labelFile, delimiter);
        return dataSet;
    }

    public static void save(ClfDataSet dataSet, File featureFile, File labelFile, String delimiter) throws Exception {
        int numDataPoints = dataSet.getNumDataPoints();
        int numFeatures = dataSet.getNumFeatures();
        try (BufferedWriter bw1 = new BufferedWriter(new FileWriter(featureFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                Vector vector = dataSet.getRow(i);
                for (int j = 0; j < numFeatures; ++j) {
                    bw1.write("" + vector.get(j));
                    if (j != numFeatures - 1) {
                        bw1.write(delimiter);
                        continue;
                    }
                    bw1.write("\n");
                }
            }
        }
        var7_7 = null;
        try (BufferedWriter bw2 = new BufferedWriter(new FileWriter(labelFile));){
            int[] labels = dataSet.getLabels();
            for (int i = 0; i < numDataPoints; ++i) {
                bw2.write("" + labels[i]);
                bw2.write("\n");
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    public static void save(MultiLabelClfDataSet dataSet, File featureFile, File labelFile, String delimiter) throws Exception {
        int numDataPoints = dataSet.getNumDataPoints();
        int numFeatures = dataSet.getNumFeatures();
        int numClasses = dataSet.getNumClasses();
        featureFile.getParentFile().mkdirs();
        labelFile.getParentFile().mkdirs();
        try (BufferedWriter bw1 = new BufferedWriter(new FileWriter(featureFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                Vector vector = dataSet.getRow(i);
                DenseVector dense = new DenseVector(vector);
                for (int j = 0; j < numFeatures; ++j) {
                    bw1.write("" + dense.get(j));
                    if (j != numFeatures - 1) {
                        bw1.write(delimiter);
                        continue;
                    }
                    bw1.write("\n");
                }
            }
        }
        var8_8 = null;
        try (BufferedWriter bw2 = new BufferedWriter(new FileWriter(labelFile));){
            MultiLabel[] labels = dataSet.getMultiLabels();
            for (int i = 0; i < numDataPoints; ++i) {
                MultiLabel label = labels[i];
                for (int l = 0; l < numClasses; ++l) {
                    if (label.matchClass(l)) {
                        bw2.write("1");
                    } else {
                        bw2.write("0");
                    }
                    if (l >= numClasses - 1) continue;
                    bw2.write(delimiter);
                }
                bw2.write("\n");
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    public static void save(RegDataSet dataSet, File featureFile, File labelFile, String delimiter) throws Exception {
        int numDataPoints = dataSet.getNumDataPoints();
        int numFeatures = dataSet.getNumFeatures();
        try (BufferedWriter bw1 = new BufferedWriter(new FileWriter(featureFile));){
            for (int i = 0; i < numDataPoints; ++i) {
                Vector vector = dataSet.getRow(i);
                for (int j = 0; j < numFeatures; ++j) {
                    bw1.write("" + vector.get(j));
                    if (j != numFeatures - 1) {
                        bw1.write(delimiter);
                        continue;
                    }
                    bw1.write("\n");
                }
            }
        }
        var7_7 = null;
        try (BufferedWriter bw2 = new BufferedWriter(new FileWriter(labelFile));){
            double[] labels = dataSet.getLabels();
            for (int i = 0; i < numDataPoints; ++i) {
                bw2.write("" + labels[i]);
                bw2.write("\n");
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    private static int[] parseStandard(File featureFile, File labelFile, String delimiter) throws IOException {
        int numDataPoints = 0;
        try (BufferedReader br1 = new BufferedReader(new FileReader(featureFile));){
            while (br1.readLine() != null) {
                ++numDataPoints;
            }
        }
        int numFeatures = 0;
        try (BufferedReader br2 = new BufferedReader(new FileReader(featureFile));){
            String line = br2.readLine();
            numFeatures = line.split(delimiter).length;
        }
        int[] stats = new int[]{numDataPoints, numFeatures};
        return stats;
    }

    private static void fill(RegDataSet regDataSet, File featureFile, File labelFile, String delimiter) throws IOException {
        int numFeatures = regDataSet.getNumFeatures();
        try (BufferedReader br1 = new BufferedReader(new FileReader(featureFile));){
            int i = 0;
            String line1 = null;
            while ((line1 = br1.readLine()) != null) {
                String[] line1Split = line1.split(delimiter);
                for (int j = 0; j < numFeatures; ++j) {
                    double featureValue = Double.parseDouble(line1Split[j]);
                    regDataSet.setFeatureValue(i, j, featureValue);
                }
                ++i;
            }
        }
        if (labelFile != null) {
            var6_6 = null;
            try (BufferedReader br2 = new BufferedReader(new FileReader(labelFile));){
                String line2 = null;
                int k = 0;
                while ((line2 = br2.readLine()) != null) {
                    String[] line2Split = line2.split(delimiter);
                    double label = Double.parseDouble(line2Split[0]);
                    regDataSet.setLabel(k, label);
                    ++k;
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    private static void fill(ClfDataSet clfDataSet, File featureFile, File labelFile, String delimiter) throws IOException {
        int numFeatures = clfDataSet.getNumFeatures();
        try (BufferedReader br1 = new BufferedReader(new FileReader(featureFile));){
            int i = 0;
            String line1 = null;
            while ((line1 = br1.readLine()) != null) {
                String[] line1Split = line1.split(delimiter);
                for (int j = 0; j < numFeatures; ++j) {
                    double featureValue = Double.parseDouble(line1Split[j]);
                    clfDataSet.setFeatureValue(i, j, featureValue);
                }
                ++i;
            }
        }
        var6_6 = null;
        try (BufferedReader br2 = new BufferedReader(new FileReader(labelFile));){
            String line2 = null;
            int k = 0;
            while ((line2 = br2.readLine()) != null) {
                String[] line2Split = line2.split(delimiter);
                int label = Integer.parseInt(line2Split[0]);
                clfDataSet.setLabel(k, label);
                ++k;
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }
}

