/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.dataset.SerializableVector;
import edu.neu.ccs.pyramid.dataset.SparseDataSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseMLClfDataSet
extends SparseDataSet
implements MultiLabelClfDataSet {
    private int numClasses;
    private MultiLabel[] multiLabels;
    private LabelTranslator labelTranslator;

    public SparseMLClfDataSet(int numDataPoints, int numFeatures, boolean missingValue, int numClasses) {
        super(numDataPoints, numFeatures, missingValue);
        this.numClasses = numClasses;
        this.multiLabels = new MultiLabel[numDataPoints];
        for (int i = 0; i < numDataPoints; ++i) {
            this.multiLabels[i] = new MultiLabel();
        }
        this.labelTranslator = LabelTranslator.newDefaultLabelTranslator(numClasses);
    }

    @Override
    public int getNumClasses() {
        return this.numClasses;
    }

    @Override
    public MultiLabel[] getMultiLabels() {
        return this.multiLabels;
    }

    @Override
    public void addLabel(int dataPointIndex, int classIndex) {
        this.multiLabels[dataPointIndex].addLabel(classIndex);
    }

    @Override
    public void setLabels(int dataPointIndex, MultiLabel multiLabel) {
        this.multiLabels[dataPointIndex] = multiLabel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("numClasses=").append(this.numClasses).append("\n");
        sb.append(super.toString());
        sb.append("labels").append("\n");
        for (int i = 0; i < this.numDataPoints; ++i) {
            sb.append(i).append(":").append(this.multiLabels[i]).append(",");
        }
        return sb.toString();
    }

    @Override
    public String getMetaInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMetaInfo());
        sb.append("type = ").append("sparse random multi-label classification").append("\n");
        sb.append("number of classes = ").append(this.numClasses);
        return sb.toString();
    }

    @Override
    public LabelTranslator getLabelTranslator() {
        return this.labelTranslator;
    }

    @Override
    public void setLabelTranslator(LabelTranslator labelTranslator) {
        this.labelTranslator = labelTranslator;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializableVector[] serFeatureRows = new SerializableVector[this.featureRows.length];
        for (int i = 0; i < this.featureRows.length; ++i) {
            serFeatureRows[i] = new SerializableVector((Vector)this.featureRows[i]);
        }
        SerializableVector[] serFeatureColumns = new SerializableVector[this.featureColumns.length];
        for (int i = 0; i < this.featureColumns.length; ++i) {
            serFeatureColumns[i] = new SerializableVector((Vector)this.featureColumns[i]);
        }
        out.writeObject(serFeatureRows);
        out.writeObject(serFeatureColumns);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializableVector[] serFeatureRows = (SerializableVector[])in.readObject();
        this.featureRows = new RandomAccessSparseVector[serFeatureRows.length];
        for (int i = 0; i < this.featureRows.length; ++i) {
            this.featureRows[i] = (RandomAccessSparseVector)serFeatureRows[i].getVector();
        }
        SerializableVector[] serFeatureColumns = (SerializableVector[])in.readObject();
        this.featureColumns = new RandomAccessSparseVector[serFeatureColumns.length];
        for (int i = 0; i < this.featureColumns.length; ++i) {
            this.featureColumns[i] = (RandomAccessSparseVector)serFeatureColumns[i].getVector();
        }
    }
}

