/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SerializableVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Type type;
    private int size;
    private transient Vector vector;

    public SerializableVector(Vector vector) {
        this.vector = vector;
        this.size = vector.size();
        this.type = vector instanceof DenseVector ? Type.DENSE : (vector instanceof RandomAccessSparseVector ? Type.SPARSE_RANDOM : Type.SPARSE_SEQUENTIAL);
    }

    public Vector getVector() {
        return this.vector;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.type == Type.DENSE) {
            double[] values = new double[this.vector.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.vector.get(i);
            }
            out.writeObject(values);
        } else {
            int numNonZeros = this.vector.getNumNonZeroElements();
            int[] indices = new int[numNonZeros];
            double[] values = new double[numNonZeros];
            int i = 0;
            for (Vector.Element element : this.vector.nonZeroes()) {
                int index = element.index();
                double v = element.get();
                indices[i] = index;
                values[i] = v;
                ++i;
            }
            out.writeObject(indices);
            out.writeObject(values);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block3: {
            block4: {
                block2: {
                    in.defaultReadObject();
                    if (this.type != Type.DENSE) break block2;
                    double[] values = (double[])in.readObject();
                    this.vector = new DenseVector(values);
                    break block3;
                }
                if (this.type != Type.SPARSE_RANDOM) break block4;
                int[] indices = (int[])in.readObject();
                double[] values = (double[])in.readObject();
                this.vector = new RandomAccessSparseVector(this.size);
                for (int i = 0; i < indices.length; ++i) {
                    this.vector.set(indices[i], values[i]);
                }
                break block3;
            }
            if (this.type != Type.SPARSE_SEQUENTIAL) break block3;
            int[] indices = (int[])in.readObject();
            double[] values = (double[])in.readObject();
            this.vector = new SequentialAccessSparseVector(this.size);
            for (int i = 0; i < indices.length; ++i) {
                this.vector.set(indices[i], values[i]);
            }
        }
    }

    private static enum Type {
        DENSE,
        SPARSE_RANDOM,
        SPARSE_SEQUENTIAL;

    }
}

