/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.DenseRegDataSet;
import edu.neu.ccs.pyramid.dataset.RegDataSet;
import edu.neu.ccs.pyramid.dataset.SparseRegDataSet;

public class RegDataSetBuilder {
    private int numDataPoints = -1;
    private int numFeatures = -1;
    private boolean dense = true;
    private boolean missingValue = false;

    public static RegDataSetBuilder getBuilder() {
        return new RegDataSetBuilder();
    }

    public RegDataSetBuilder numDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
        return this;
    }

    public RegDataSetBuilder numFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
        return this;
    }

    public RegDataSetBuilder dense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public RegDataSetBuilder missingValue(boolean missingValue) {
        this.missingValue = missingValue;
        return this;
    }

    public RegDataSet build() {
        if (!this.valid()) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        AbstractDataSet dataSet = this.dense ? new DenseRegDataSet(this.numDataPoints, this.numFeatures, this.missingValue) : new SparseRegDataSet(this.numDataPoints, this.numFeatures, this.missingValue);
        return dataSet;
    }

    private boolean valid() {
        if (this.numDataPoints <= 0) {
            return false;
        }
        return this.numFeatures > 0;
    }
}

