/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public interface MultiLabelClfDataSet
extends DataSet {
    public MultiLabel[] getMultiLabels();

    public void addLabel(int var1, int var2);

    default public void addLabels(int dataPointIndex, Collection<Integer> labels) {
        for (Integer label : labels) {
            this.addLabel(dataPointIndex, label);
        }
    }

    public void setLabels(int var1, MultiLabel var2);

    public int getNumClasses();

    public LabelTranslator getLabelTranslator();

    public void setLabelTranslator(LabelTranslator var1);

    default public double labelCardinality() {
        MultiLabel[] multiLabels = this.getMultiLabels();
        return ((Stream)Arrays.stream(multiLabels).parallel()).mapToDouble(multiLabel -> multiLabel.getMatchedLabels().size()).average().getAsDouble();
    }

    default public double labelDensity() {
        return this.labelCardinality() / (double)this.getNumClasses();
    }
}

