/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MLClfDataSetBuilder;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.FeatureList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.mahout.math.Vector;

public class MekaFormat {
    public static MultiLabelClfDataSet loadMLClfDataset(String fileName, int numFeatures, int numClasses, String dataMode) throws IOException {
        switch (dataMode) {
            case "sparse": {
                return MekaFormat.loadMLClfDataset(new File(fileName), numFeatures, numClasses);
            }
            case "pre.sparse": {
                return MekaFormat.loadMLClfDatasetPre(new File(fileName), numFeatures, numClasses);
            }
            case "dense": {
                return MekaFormat.loadMLClfDatasetDense(new File(fileName), numFeatures, numClasses);
            }
            case "pre.dense": {
                return MekaFormat.loadMLClfDatasetPreDense(new File(fileName), numFeatures, numClasses);
            }
        }
        throw new RuntimeException("not acceptable data mode: " + dataMode);
    }

    private static MultiLabelClfDataSet loadMLClfDatasetPreDense(File file, int numFeatures, int numClasses) throws IOException {
        String line;
        int numData = 0;
        HashMap<String, String> labelMap = new HashMap<String, String>();
        HashMap<String, String> featureMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        int featureCount = -1;
        boolean ifData = false;
        while ((line = br.readLine()) != null) {
            String[] splitLine;
            if (line.startsWith("@data")) {
                ifData = true;
                continue;
            }
            if (featureCount < numFeatures) {
                if (!line.startsWith("@attribute")) continue;
                if (featureCount == -1) {
                    ++featureCount;
                    continue;
                }
                splitLine = line.split(" ");
                String featureName = splitLine[1];
                String featureIndex = Integer.toString(featureCount);
                featureMap.put(featureIndex, featureName);
                ++featureCount;
                continue;
            }
            if (line.startsWith("@attribute")) {
                splitLine = line.split(" ");
                String labelName = splitLine[1];
                String labelIndex = Integer.toString(featureCount);
                labelMap.put(labelIndex, labelName);
                ++featureCount;
                continue;
            }
            if (!ifData || line.length() < 2) continue;
            ++numData;
        }
        br.close();
        return MekaFormat.loadMLClfDatasetPreDense(file, numClasses, numFeatures, numData, labelMap, featureMap);
    }

    private static MultiLabelClfDataSet loadMLClfDatasetPreDense(File file, int numClasses, int numFeatures, int numData, Map<String, String> labelMap, Map<String, String> featureMap) throws IOException {
        String line;
        MultiLabelClfDataSet dataSet = MLClfDataSetBuilder.getBuilder().numDataPoints(numData).numClasses(numClasses).numFeatures(numFeatures).build();
        LinkedList<Feature> featureList = new LinkedList<Feature>();
        for (int m = 0; m < numFeatures; ++m) {
            String featureIndex = Integer.toString(m);
            String string = featureMap.get(featureIndex);
            Feature feature = new Feature();
            feature.setIndex(m);
            feature.setName(string);
            featureList.add(feature);
        }
        dataSet.setFeatureList(new FeatureList(featureList));
        HashMap<Integer, String> labelIndexMap = new HashMap<Integer, String>();
        for (Map.Entry entry : labelMap.entrySet()) {
            String labelString = (String)entry.getKey();
            String labelName = (String)entry.getValue();
            labelIndexMap.put(Integer.parseInt(labelString) - numFeatures, labelName);
        }
        LabelTranslator labelTranslator = new LabelTranslator(labelIndexMap);
        dataSet.setLabelTranslator(labelTranslator);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int dataCount = 0;
        boolean ifData = false;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("@data")) {
                ifData = true;
                continue;
            }
            if (!ifData) continue;
            if (line.startsWith("{") && line.endsWith("}")) {
                line = line.substring(1, line.length() - 1);
            }
            String[] indexValues = line.split(",");
            int indexValueI = -2;
            for (String indexValue : indexValues) {
                double valueDouble;
                if (++indexValueI == -1) continue;
                String index = Integer.toString(indexValueI);
                String value = indexValue;
                if (labelMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    if (valueDouble != 1.0) continue;
                    dataSet.addLabel(dataCount, Integer.parseInt(index) - numFeatures);
                    continue;
                }
                if (featureMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    int indexInt = Integer.parseInt(index);
                    dataSet.setFeatureValue(dataCount, indexInt, valueDouble);
                    continue;
                }
                throw new RuntimeException("Index not found in the line: " + line);
            }
            ++dataCount;
        }
        bufferedReader.close();
        return dataSet;
    }

    private static MultiLabelClfDataSet loadMLClfDatasetDense(File file, int numFeatures, int numClasses) throws IOException {
        String line;
        int numData = 0;
        HashMap<String, String> labelMap = new HashMap<String, String>();
        HashMap<String, String> featureMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        int featureCount = 0;
        boolean ifData = false;
        while ((line = br.readLine()) != null) {
            String[] splitLine;
            if (line.startsWith("@data")) {
                ifData = true;
                continue;
            }
            if (featureCount < numFeatures) {
                if (!line.startsWith("@attribute")) continue;
                splitLine = line.split(" ");
                String featureName = splitLine[1];
                String featureIndex = Integer.toString(featureCount);
                featureMap.put(featureIndex, featureName);
                ++featureCount;
                continue;
            }
            if (line.startsWith("@attribute")) {
                splitLine = line.split(" ");
                String labelName = splitLine[1];
                String labelIndex = Integer.toString(featureCount);
                labelMap.put(labelIndex, labelName);
                ++featureCount;
                continue;
            }
            if (!ifData || line.length() < 2) continue;
            ++numData;
        }
        br.close();
        return MekaFormat.loadMLClfDatasetDense(file, numClasses, numFeatures, numData, labelMap, featureMap);
    }

    private static MultiLabelClfDataSet loadMLClfDatasetDense(File file, int numClasses, int numFeatures, int numData, Map<String, String> labelMap, Map<String, String> featureMap) throws IOException {
        String line;
        MultiLabelClfDataSet dataSet = MLClfDataSetBuilder.getBuilder().numDataPoints(numData).numClasses(numClasses).numFeatures(numFeatures).build();
        LinkedList<Feature> featureList = new LinkedList<Feature>();
        for (int m = 0; m < numFeatures; ++m) {
            String featureIndex = Integer.toString(m);
            String string = featureMap.get(featureIndex);
            Feature feature = new Feature();
            feature.setIndex(m);
            feature.setName(string);
            featureList.add(feature);
        }
        dataSet.setFeatureList(new FeatureList(featureList));
        HashMap<Integer, String> labelIndexMap = new HashMap<Integer, String>();
        for (Map.Entry entry : labelMap.entrySet()) {
            String labelString = (String)entry.getKey();
            String labelName = (String)entry.getValue();
            labelIndexMap.put(Integer.parseInt(labelString) - numFeatures, labelName);
        }
        LabelTranslator labelTranslator = new LabelTranslator(labelIndexMap);
        dataSet.setLabelTranslator(labelTranslator);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int dataCount = 0;
        boolean ifData = false;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("@data")) {
                ifData = true;
                continue;
            }
            if (!ifData) continue;
            if (line.startsWith("{") && line.endsWith("}")) {
                line = line.substring(1, line.length() - 1);
            }
            String[] indexValues = line.split(",");
            int indexValueI = -1;
            for (String indexValue : indexValues) {
                double valueDouble;
                String index = Integer.toString(++indexValueI);
                String value = indexValue;
                if (labelMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    if (valueDouble != 1.0) continue;
                    dataSet.addLabel(dataCount, Integer.parseInt(index) - numFeatures);
                    continue;
                }
                if (featureMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    int indexInt = Integer.parseInt(index);
                    dataSet.setFeatureValue(dataCount, indexInt, valueDouble);
                    continue;
                }
                throw new RuntimeException("Index not found in the line: " + line);
            }
            ++dataCount;
        }
        bufferedReader.close();
        return dataSet;
    }

    private static MultiLabelClfDataSet loadMLClfDatasetPre(File file, int numFeatures, int numClasses) throws IOException {
        String line;
        int numData = 0;
        HashMap<String, String> labelMap = new HashMap<String, String>();
        HashMap<String, String> featureMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        int labelCount = 0;
        while ((line = br.readLine()) != null) {
            String[] splitLine;
            if (labelCount < numClasses) {
                if (!line.startsWith("@attribute")) continue;
                splitLine = line.split(" ");
                String labelName = splitLine[1];
                String labelIndex = Integer.toString(labelCount);
                labelMap.put(labelIndex, labelName);
                ++labelCount;
                continue;
            }
            if (line.startsWith("@attribute")) {
                splitLine = line.split(" ");
                String featureName = splitLine[1];
                String featureIndex = Integer.toString(labelCount);
                featureMap.put(featureIndex, featureName);
                ++labelCount;
                continue;
            }
            if (!line.startsWith("{") || !line.endsWith("}")) continue;
            ++numData;
        }
        br.close();
        return MekaFormat.loadMLClfDatasetPre(file, numClasses, numFeatures, numData, labelMap, featureMap);
    }

    private static MultiLabelClfDataSet loadMLClfDatasetPre(File file, int numClasses, int numFeatures, int numData, Map<String, String> labelMap, Map<String, String> featureMap) throws IOException {
        String line;
        MultiLabelClfDataSet dataSet = MLClfDataSetBuilder.getBuilder().numDataPoints(numData).numClasses(numClasses).numFeatures(numFeatures).build();
        LinkedList<Feature> featureList = new LinkedList<Feature>();
        for (int m = 0; m < numFeatures; ++m) {
            String featureIndex = Integer.toString(m + numClasses);
            String string = featureMap.get(featureIndex);
            Feature feature = new Feature();
            feature.setIndex(m);
            feature.setName(string);
            featureList.add(feature);
        }
        dataSet.setFeatureList(new FeatureList(featureList));
        HashMap<Integer, String> labelIndexMap = new HashMap<Integer, String>();
        for (Map.Entry entry : labelMap.entrySet()) {
            String labelString = (String)entry.getKey();
            String labelName = (String)entry.getValue();
            labelIndexMap.put(Integer.parseInt(labelString), labelName);
        }
        LabelTranslator labelTranslator = new LabelTranslator(labelIndexMap);
        dataSet.setLabelTranslator(labelTranslator);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int dataCount = 0;
        while ((line = bufferedReader.readLine()) != null) {
            String[] indexValues;
            if (!line.startsWith("{") || !line.endsWith("}")) continue;
            line = line.substring(1, line.length() - 1);
            for (String indexValue : indexValues = line.split(",")) {
                double valueDouble;
                String[] indexValuePair = indexValue.split(" ");
                String index = indexValuePair[0];
                String value = indexValuePair[1];
                if (labelMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    if (valueDouble != 1.0) continue;
                    dataSet.addLabel(dataCount, Integer.parseInt(index));
                    continue;
                }
                if (featureMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    int indexInt = Integer.parseInt(index);
                    dataSet.setFeatureValue(dataCount, indexInt - numClasses, valueDouble);
                    continue;
                }
                throw new RuntimeException("Index not found in the line: " + line);
            }
            ++dataCount;
        }
        bufferedReader.close();
        return dataSet;
    }

    private static MultiLabelClfDataSet loadMLClfDataset(File file, int numFeatures, int numClasses) throws IOException {
        String line;
        int numData = 0;
        HashMap<String, String> labelMap = new HashMap<String, String>();
        HashMap<String, String> featureMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        int featureCount = 0;
        while ((line = br.readLine()) != null) {
            String[] splitLine;
            if (featureCount < numFeatures) {
                if (!line.startsWith("@attribute")) continue;
                splitLine = line.split(" ");
                String featureName = splitLine[1];
                String featureIndex = Integer.toString(featureCount);
                featureMap.put(featureIndex, featureName);
                ++featureCount;
                continue;
            }
            if (line.startsWith("@attribute")) {
                splitLine = line.split(" ");
                String labelName = splitLine[1];
                String labelIndex = Integer.toString(featureCount);
                labelMap.put(labelIndex, labelName);
                ++featureCount;
                continue;
            }
            if (!line.startsWith("{") || !line.endsWith("}")) continue;
            ++numData;
        }
        br.close();
        System.out.println("numData: " + numData);
        return MekaFormat.loadMLClfDataset(file, numClasses, numFeatures, numData, labelMap, featureMap);
    }

    private static MultiLabelClfDataSet loadMLClfDataset(File file, int numClasses, int numFeatures, int numData, Map<String, String> labelMap, Map<String, String> featureMap) throws IOException {
        String line;
        MultiLabelClfDataSet dataSet = MLClfDataSetBuilder.getBuilder().numDataPoints(numData).numClasses(numClasses).numFeatures(numFeatures).build();
        LinkedList<Feature> featureList = new LinkedList<Feature>();
        for (int m = 0; m < numFeatures; ++m) {
            String featureIndex = Integer.toString(m);
            String string = featureMap.get(featureIndex);
            Feature feature = new Feature();
            feature.setIndex(m);
            feature.setName(string);
            featureList.add(feature);
        }
        dataSet.setFeatureList(new FeatureList(featureList));
        HashMap<Integer, String> labelIndexMap = new HashMap<Integer, String>();
        for (Map.Entry entry : labelMap.entrySet()) {
            String labelString = (String)entry.getKey();
            String labelName = (String)entry.getValue();
            labelIndexMap.put(Integer.parseInt(labelString) - numFeatures, labelName);
        }
        LabelTranslator labelTranslator = new LabelTranslator(labelIndexMap);
        dataSet.setLabelTranslator(labelTranslator);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int dataCount = 0;
        while ((line = bufferedReader.readLine()) != null) {
            String[] indexValues;
            if (!line.startsWith("{") || !line.endsWith("}")) continue;
            line = line.substring(1, line.length() - 1);
            for (String indexValue : indexValues = line.split(", ")) {
                double valueDouble;
                String[] indexValuePair = indexValue.split(" ");
                String index = indexValuePair[0];
                String value = indexValuePair[1];
                if (labelMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    if (valueDouble != 1.0) continue;
                    dataSet.addLabel(dataCount, Integer.parseInt(index) - numFeatures);
                    continue;
                }
                if (featureMap.containsKey(index)) {
                    valueDouble = Double.parseDouble(value);
                    int indexInt = Integer.parseInt(index);
                    dataSet.setFeatureValue(dataCount, indexInt, valueDouble);
                    continue;
                }
                throw new RuntimeException("Index:" + index + " not found in the line: " + line);
            }
            ++dataCount;
        }
        bufferedReader.close();
        return dataSet;
    }

    public static void save(MultiLabelClfDataSet dataSet, String mekaFile, String dataName) throws IOException {
        int i;
        BufferedWriter bw = new BufferedWriter(new FileWriter(mekaFile));
        LabelTranslator labelTranslator = dataSet.getLabelTranslator();
        int numClasses = labelTranslator.getNumClasses();
        bw.write("@relation '" + dataName + ": -C " + numClasses + "'\n\n");
        FeatureList featureList = dataSet.getFeatureList();
        for (i = 0; i < featureList.size(); ++i) {
            Feature feature = featureList.get(i);
            String featureName = "f" + i;
            bw.write("@attribute " + featureName + " numeric\n");
        }
        for (i = 0; i < numClasses; ++i) {
            String labelName = labelTranslator.toExtLabel(i);
            bw.write("@attribute " + labelName.replace(" ", "_") + " {0,1}\n");
        }
        MultiLabel[] multiLabels = dataSet.getMultiLabels();
        bw.write("\n@data\n\n");
        for (int i2 = 0; i2 < dataSet.getNumDataPoints(); ++i2) {
            Object element2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            Vector rowData = dataSet.getRow(i2);
            MultiLabel multiLabel = multiLabels[i2];
            TreeMap<Integer, Double> sortedKeys = new TreeMap<Integer, Double>();
            for (Object element2 : rowData.nonZeroes()) {
                int index = element2.index();
                double value = element2.get();
                sortedKeys.put(index, value);
            }
            int count = 0;
            element2 = sortedKeys.entrySet().iterator();
            while (element2.hasNext()) {
                Map.Entry entry = (Map.Entry)element2.next();
                int index = (Integer)entry.getKey();
                double value = (Double)entry.getValue();
                stringBuffer.append(index + " " + value);
                if (++count >= sortedKeys.size()) continue;
                stringBuffer.append(",");
            }
            List<Integer> matchedLabels = multiLabel.getMatchedLabelsOrdered();
            for (int j = 0; j < matchedLabels.size(); ++j) {
                int matchedLabel = matchedLabels.get(j) + dataSet.getNumFeatures();
                stringBuffer.append("," + matchedLabel + " 1");
            }
            stringBuffer.append("}\n");
            bw.write(stringBuffer.toString());
        }
        bw.close();
    }

    public static void saveXML(MultiLabelClfDataSet dataSet, String xmlFile) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(xmlFile));
        bw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        bw.write("<labels xmlns=\"http://mulan.sourceforge.net/labels\">\n");
        LabelTranslator labelTranslator = dataSet.getLabelTranslator();
        for (int i = 0; i < labelTranslator.getNumClasses(); ++i) {
            String labelName = labelTranslator.toExtLabel(i);
            bw.write("<label name=\"" + labelName.replace(" ", "_") + "\"></label>\n");
        }
        bw.write("</labels>");
        bw.close();
    }
}

