/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.DenseMLClfDataSet;
import edu.neu.ccs.pyramid.dataset.Density;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.dataset.SequentialSparseMLClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseMLClfDataSet;

public class MLClfDataSetBuilder {
    private int numDataPoints = -1;
    private int numFeatures = -1;
    private boolean missingValue = false;
    private int numClasses = -1;
    private Density density = Density.DENSE;

    public static MLClfDataSetBuilder getBuilder() {
        return new MLClfDataSetBuilder();
    }

    public MLClfDataSetBuilder numDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
        return this;
    }

    public MLClfDataSetBuilder numFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
        return this;
    }

    public MLClfDataSetBuilder density(Density density) {
        this.density = density;
        return this;
    }

    public MLClfDataSetBuilder missingValue(boolean missingValue) {
        this.missingValue = missingValue;
        return this;
    }

    public MLClfDataSetBuilder numClasses(int numClasses) {
        this.numClasses = numClasses;
        return this;
    }

    public MultiLabelClfDataSet build() {
        if (this.numDataPoints <= 0) {
            throw new RuntimeException("numDataPoints<=0");
        }
        if (this.numFeatures <= 0) {
            throw new RuntimeException("numFeatures<=0");
        }
        if (this.numClasses <= 0) {
            throw new RuntimeException("numClasses<=0");
        }
        AbstractDataSet dataSet = null;
        switch (this.density) {
            case DENSE: {
                dataSet = new DenseMLClfDataSet(this.numDataPoints, this.numFeatures, this.missingValue, this.numClasses);
                break;
            }
            case SPARSE_RANDOM: {
                dataSet = new SparseMLClfDataSet(this.numDataPoints, this.numFeatures, this.missingValue, this.numClasses);
                break;
            }
            case SPARSE_SEQUENTIAL: {
                dataSet = new SequentialSparseMLClfDataSet(this.numDataPoints, this.numFeatures, this.missingValue, this.numClasses);
            }
        }
        return dataSet;
    }
}

