/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LabelTranslator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, String> intToExt = new HashMap<Integer, String>();
    private Map<String, Integer> extToInt = new HashMap<String, Integer>();

    public LabelTranslator(List<String> extLabels) {
        this();
        for (int i = 0; i < extLabels.size(); ++i) {
            String extLabel = extLabels.get(i);
            this.intToExt.put(i, extLabel);
            this.extToInt.put(extLabel, i);
        }
    }

    public LabelTranslator(String[] extLabels) {
        this();
        for (int i = 0; i < extLabels.length; ++i) {
            String extLabel = extLabels[i];
            this.intToExt.put(i, extLabel);
            this.extToInt.put(extLabel, i);
        }
    }

    public LabelTranslator(Map<Integer, String> intToExtMap) {
        this();
        for (Map.Entry<Integer, String> entry : intToExtMap.entrySet()) {
            Integer intLabel = entry.getKey();
            String extLabel = entry.getValue();
            this.intToExt.put(intLabel, extLabel);
            this.extToInt.put(extLabel, intLabel);
        }
    }

    public LabelTranslator(Set<String> extLabels) {
        this();
        List extLabelList = extLabels.stream().sorted().collect(Collectors.toList());
        for (int i = 0; i < extLabelList.size(); ++i) {
            String extLabel = (String)extLabelList.get(i);
            this.intToExt.put(i, extLabel);
            this.extToInt.put(extLabel, i);
        }
    }

    public String toExtLabel(int intLabel) {
        return this.intToExt.get(intLabel);
    }

    public int toIntLabel(String extLabel) {
        return this.extToInt.get(extLabel);
    }

    private LabelTranslator() {
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public int getNumClasses() {
        return this.intToExt.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, String> entry : this.intToExt.entrySet()) {
            sb.append("" + entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static LabelTranslator newDefaultLabelTranslator(int numClasses) {
        List<String> extLabels = IntStream.range(0, numClasses).mapToObj(i -> "" + i).collect(Collectors.toList());
        return new LabelTranslator(extLabels);
    }

    public static class Builder {
        private Set<String> extLabels = new HashSet<String>();

        Builder() {
        }

        public Builder addExtLabel(String extLabel) {
            this.extLabels.add(extLabel);
            return this;
        }

        public Builder addExtLabels(Collection<String> extLabels) {
            this.extLabels.addAll(extLabels);
            return this;
        }

        public LabelTranslator build() {
            LabelTranslator translator = new LabelTranslator();
            List extLabelList = this.extLabels.stream().sorted().collect(Collectors.toList());
            for (int i = 0; i < extLabelList.size(); ++i) {
                String extLabel = (String)extLabelList.get(i);
                translator.intToExt.put(i, extLabel);
                translator.extToInt.put(extLabel, i);
            }
            return translator;
        }
    }
}

