/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class LabelGraph
implements Serializable {
    int numLabels;
    private Set<Integer> destLabelSet;
    private Map<Integer, String> intExtLabelMap;
    private Map<String, Integer> extIntLabelMap;
    private Map<Integer, Set<Integer>> DirectedEdgeMap;
    private Map<Integer, Set<Integer>> InversedDirectedEdgeMap;
    private Map<Integer, Set<Integer>> UndirectedEdgeMap;

    public LabelGraph(int numLabels) {
        this.numLabels = numLabels;
        this.destLabelSet = new HashSet<Integer>();
        this.intExtLabelMap = new HashMap<Integer, String>();
        this.extIntLabelMap = new HashMap<String, Integer>();
        this.DirectedEdgeMap = new HashMap<Integer, Set<Integer>>();
        this.InversedDirectedEdgeMap = new HashMap<Integer, Set<Integer>>();
        this.UndirectedEdgeMap = new HashMap<Integer, Set<Integer>>();
    }

    public String getExtLabel(int intLabel) {
        String extLabel = null;
        if (this.intExtLabelMap.containsKey(intLabel)) {
            extLabel = this.intExtLabelMap.get(intLabel);
        }
        return extLabel;
    }

    public int getIntLabel(String extLabel) {
        int intLabel = -1;
        if (this.extIntLabelMap.containsKey(extLabel)) {
            intLabel = this.extIntLabelMap.get(extLabel);
        }
        return intLabel;
    }

    public void setHierarchyEdge(int srcLabel, int destLabel) {
        Set<Object> edges1 = this.DirectedEdgeMap.containsKey(srcLabel) ? this.DirectedEdgeMap.get(srcLabel) : new HashSet();
        Set<Object> edges2 = this.InversedDirectedEdgeMap.containsKey(destLabel) ? this.InversedDirectedEdgeMap.get(destLabel) : new HashSet();
        edges1.add(destLabel);
        edges2.add(srcLabel);
        this.DirectedEdgeMap.put(srcLabel, edges1);
        this.InversedDirectedEdgeMap.put(destLabel, edges2);
    }

    public void setExclusionEdge(int srcLabel, int destLabel) {
        if (srcLabel != destLabel) {
            Set<Object> edges1 = this.UndirectedEdgeMap.containsKey(srcLabel) ? this.UndirectedEdgeMap.get(srcLabel) : new HashSet();
            Set<Object> edges2 = this.UndirectedEdgeMap.containsKey(destLabel) ? this.UndirectedEdgeMap.get(destLabel) : new HashSet();
            edges1.add(destLabel);
            edges2.add(srcLabel);
            this.UndirectedEdgeMap.put(srcLabel, edges1);
            this.UndirectedEdgeMap.put(destLabel, edges2);
        }
    }

    public Set<Integer> getAncestorLabels(int label) {
        Set<Integer> ancestors = new HashSet<Integer>();
        ancestors = this.getAncestorLabelsHelper(label, ancestors);
        return ancestors;
    }

    public Set<Integer> getAncestorLabelsHelper(int label, Set<Integer> ancestors) {
        if (this.InversedDirectedEdgeMap.containsKey(label)) {
            for (int i : this.InversedDirectedEdgeMap.get(label)) {
                if (ancestors.contains(i)) continue;
                ancestors.add(i);
                ancestors = this.getAncestorLabelsHelper(i, ancestors);
            }
        }
        return ancestors;
    }

    public Set<Integer> getDescendantLabels(int label) {
        Set<Integer> descendants = new HashSet<Integer>();
        descendants = this.getDescendantLabelsHelper(label, descendants);
        return descendants;
    }

    public Set<Integer> getDescendantLabelsHelper(int label, Set<Integer> descendants) {
        if (this.DirectedEdgeMap.containsKey(label)) {
            for (int i : this.DirectedEdgeMap.get(label)) {
                if (descendants.contains(i)) continue;
                descendants.add(i);
                descendants = this.getDescendantLabelsHelper(i, descendants);
            }
        }
        return descendants;
    }

    public Set<Integer> getExclusiveLabels(int label) {
        Set<Integer> exclusions = new HashSet<Integer>();
        exclusions = this.getExclusiveLabelsHelper(label, exclusions);
        exclusions.remove(label);
        return exclusions;
    }

    public Set<Integer> getExclusiveLabelsHelper(int label, Set<Integer> exclusions) {
        if (this.UndirectedEdgeMap.containsKey(label)) {
            for (int i : this.UndirectedEdgeMap.get(label)) {
                if (exclusions.contains(i)) continue;
                exclusions.add(i);
                exclusions = this.getExclusiveLabelsHelper(i, exclusions);
            }
        }
        return exclusions;
    }

    public boolean isConsistent() {
        for (int i = 0; i < this.numLabels; ++i) {
            Set<Integer> ancestors = this.getAncestorLabels(i);
            ancestors.add(i);
            for (int j : ancestors) {
                Set<Integer> exclusions = this.getExclusiveLabels(j);
                for (int k : ancestors) {
                    if (!exclusions.contains(k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isHierarchySubGraphDag() {
        Stack<Integer> dagStack = new Stack<Integer>();
        HashSet<Integer> uncheckedLabels = new HashSet<Integer>();
        for (int i = 0; i < this.numLabels; ++i) {
            uncheckedLabels.add(i);
        }
        while (!uncheckedLabels.isEmpty()) {
            Iterator iter = uncheckedLabels.iterator();
            if (this.isDag((Integer)iter.next(), dagStack, uncheckedLabels)) continue;
            return false;
        }
        return true;
    }

    public boolean isDag(int label, Stack<Integer> dagStack, Set<Integer> uncheckedLabels) {
        uncheckedLabels.remove(label);
        if (dagStack.contains(label)) {
            return false;
        }
        dagStack.push(label);
        Set<Integer> descendants = this.DirectedEdgeMap.get(label);
        if (this.DirectedEdgeMap.containsKey(label)) {
            for (int i : descendants) {
                if (this.isDag(i, dagStack, uncheckedLabels)) continue;
                return false;
            }
        }
        dagStack.pop();
        return true;
    }

    public boolean isAssignmentLegal(MultiLabel assignment) {
        int i;
        for (i = 0; i < this.numLabels; ++i) {
            Set<Integer> descendants = this.getDescendantLabels(i);
            if (!this.DirectedEdgeMap.containsKey(i) || assignment.matchClass(i)) continue;
            for (int j : descendants) {
                if (!assignment.matchClass(j)) continue;
                return false;
            }
        }
        for (i = 0; i < this.numLabels; ++i) {
            Set<Integer> exclusions = this.getExclusiveLabels(i);
            if (!this.UndirectedEdgeMap.containsKey(i) || !assignment.matchClass(i)) continue;
            for (int j : exclusions) {
                if (!assignment.matchClass(j)) continue;
                return false;
            }
        }
        return true;
    }

    public List<MultiLabel> getLegalAssignments() {
        ArrayList<MultiLabel> assignments = new ArrayList<MultiLabel>();
        int i = 1;
        while ((double)i < Math.pow(2.0, this.numLabels)) {
            boolean flag = false;
            String biLabel = Integer.toBinaryString(i);
            MultiLabel assignment = new MultiLabel();
            int j = this.numLabels - biLabel.length();
            int k = this.numLabels - biLabel.length();
            while (j < this.numLabels) {
                if (biLabel.charAt(j - this.numLabels + biLabel.length()) == '1') {
                    assignment.addLabel(k);
                    if (this.destLabelSet.contains(k)) {
                        flag = true;
                    }
                }
                ++j;
                ++k;
            }
            if (flag && this.isAssignmentLegal(assignment)) {
                assignments.add(assignment);
            }
            ++i;
        }
        return assignments;
    }

    public static boolean isEquivalent(LabelGraph lg1, LabelGraph lg2) {
        if (!lg1.isHierarchySubGraphDag() || !lg2.isHierarchySubGraphDag()) {
            return false;
        }
        List<MultiLabel> assignments1 = lg1.getLegalAssignments();
        List<MultiLabel> assignments2 = lg2.getLegalAssignments();
        if (assignments1.size() != assignments2.size()) {
            return false;
        }
        for (int i = 0; i < assignments1.size(); ++i) {
            if (assignments1.get(i).equals(assignments2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isMinimallySparse() {
        for (int i = 0; i < this.numLabels; ++i) {
            if (this.DirectedEdgeMap.containsKey(i)) {
                for (int j : this.DirectedEdgeMap.get(i)) {
                    if (!this.isRedundantDirectedEdge(i, j)) continue;
                    return false;
                }
            }
            if (!this.UndirectedEdgeMap.containsKey(i)) continue;
            for (int j : this.UndirectedEdgeMap.get(i)) {
                if (!this.isRedundantUndirectedEdge(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMaximallyDense() {
        for (int i = 0; i < this.numLabels; ++i) {
            if (this.DirectedEdgeMap.containsKey(i)) {
                for (int j : this.DirectedEdgeMap.get(i)) {
                    if (this.isRedundantDirectedEdge(i, j)) continue;
                    return false;
                }
            }
            if (!this.UndirectedEdgeMap.containsKey(i)) continue;
            for (int j : this.UndirectedEdgeMap.get(i)) {
                if (this.isRedundantUndirectedEdge(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRedundantDirectedEdge(int srcLabel, int destLabel) {
        if (this.DirectedEdgeMap.get(srcLabel).contains(destLabel)) {
            Set<Integer> descendants = this.DirectedEdgeMap.get(srcLabel);
            HashSet<Integer> labels = new HashSet<Integer>();
            for (int i : descendants) {
                if (i == destLabel) continue;
                labels.addAll(this.getDescendantLabels(i));
            }
            return labels.contains(destLabel);
        }
        return false;
    }

    public boolean isRedundantUndirectedEdge(int srcLabel, int destLabel) {
        if (this.UndirectedEdgeMap.get(srcLabel).contains(destLabel)) {
            Set<Integer> exclusions = this.UndirectedEdgeMap.get(srcLabel);
            HashSet<Integer> labels = new HashSet<Integer>();
            for (int i : exclusions) {
                if (i == destLabel) continue;
                labels.addAll(this.getExclusiveLabels(i));
            }
            return labels.contains(destLabel);
        }
        return false;
    }

    public static LabelGraph sparsify(LabelGraph labelGraph) {
        for (int i = 0; i < labelGraph.numLabels; ++i) {
            if (labelGraph.DirectedEdgeMap.containsKey(i)) {
                for (int j : labelGraph.DirectedEdgeMap.get(i)) {
                    if (!labelGraph.isRedundantDirectedEdge(i, j)) continue;
                    labelGraph.DirectedEdgeMap.get(i).remove(j);
                }
            }
            if (!labelGraph.UndirectedEdgeMap.containsKey(i)) continue;
            for (int j : labelGraph.UndirectedEdgeMap.get(i)) {
                if (!labelGraph.isRedundantUndirectedEdge(i, j)) continue;
                labelGraph.UndirectedEdgeMap.get(i).remove(j);
            }
        }
        return labelGraph;
    }

    public void parser(String operator) {
        String[] words = operator.split(" ");
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (words.length == 2) {
            if (pattern.matcher(words[0]).matches()) {
                int parent = Integer.parseInt(words[0]);
                Set<Integer> children = this.DirectedEdgeMap.get(parent);
                for (int i : children) {
                    for (int j : children) {
                        if (i >= j) continue;
                        this.setExclusionEdge(i, j);
                    }
                }
            } else {
                String dest = words[1];
                String[] dests = dest.split(",");
                for (int i = 0; i < dests.length; ++i) {
                    if (this.destLabelSet.contains(dests[i])) continue;
                    this.destLabelSet.add(Integer.parseInt(dests[i]));
                }
            }
        } else if (words[1].contains("hier")) {
            int parent = Integer.parseInt(words[0]);
            String[] children = words[2].split(",");
            for (int i = 0; i < children.length; ++i) {
                this.setHierarchyEdge(parent, Integer.parseInt(children[i]));
            }
        } else {
            int left = Integer.parseInt(words[0]);
            String[] rights = words[2].split(",");
            for (int i = 0; i < rights.length; ++i) {
                this.setExclusionEdge(left, Integer.parseInt(rights[i]));
            }
        }
    }
}

