/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IdTranslator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, String> intToExt = new ConcurrentHashMap<Integer, String>();
    private Map<String, Integer> extToInt = new ConcurrentHashMap<String, Integer>();

    public int numData() {
        return this.intToExt.size();
    }

    public String[] getAllExtIds() {
        return this.extToInt.keySet().toArray(new String[0]);
    }

    public void addData(int intId, String extId) {
        if (this.intToExt.containsKey(intId)) {
            throw new IllegalArgumentException(intId + "already exists");
        }
        if (this.extToInt.containsKey(extId)) {
            throw new IllegalArgumentException(extId + "already exists");
        }
        this.intToExt.put(intId, extId);
        this.extToInt.put(extId, intId);
    }

    public void addDataWithoutCheck(int intId, String extId) {
        this.intToExt.put(intId, extId);
        this.extToInt.put(extId, intId);
    }

    public int toIntId(String extId) {
        return this.extToInt.get(extId);
    }

    public String toExtId(int intId) {
        return this.intToExt.get(intId);
    }

    public void serialize(File file) throws Exception {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    public void serialize(String file) throws Exception {
        File file1 = new File(file);
        this.serialize(file1);
    }

    /*
     * Exception decompiling
     */
    public static IdTranslator deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IdTranslator deserialize(String file) throws Exception {
        File file1 = new File(file);
        return IdTranslator.deserialize(file1);
    }

    public static IdTranslator newDefaultIdTranslator(int numDataPoints) {
        IdTranslator idTranslator = new IdTranslator();
        for (int i = 0; i < numDataPoints; ++i) {
            idTranslator.addData(i, "" + i);
        }
        return idTranslator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, String> entry : this.intToExt.entrySet()) {
            sb.append("" + entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

