/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.Density;
import edu.neu.ccs.pyramid.dataset.SerializableVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

class DenseDataSet
extends AbstractDataSet
implements DataSet {
    protected transient DenseVector[] featureRows;
    protected transient DenseVector[] featureColumns;

    DenseDataSet(int numDataPoints, int numFeatures, boolean missingValue) {
        super(numDataPoints, numFeatures, missingValue);
        this.featureRows = new DenseVector[numDataPoints];
        for (int i = 0; i < numDataPoints; ++i) {
            this.featureRows[i] = new DenseVector(numFeatures);
        }
        this.featureColumns = new DenseVector[numFeatures];
        for (int j = 0; j < numFeatures; ++j) {
            this.featureColumns[j] = new DenseVector(numDataPoints);
        }
    }

    @Override
    public Density density() {
        return Density.DENSE;
    }

    @Override
    public Vector getColumn(int featureIndex) {
        return this.featureColumns[featureIndex];
    }

    @Override
    public Vector getRow(int dataPointIndex) {
        return this.featureRows[dataPointIndex];
    }

    @Override
    public void setFeatureValue(int dataPointIndex, int featureIndex, double featureValue) {
        if (!this.hasMissingValue() && Double.isNaN(featureValue)) {
            throw new IllegalArgumentException("missing value is not allowed in this data set");
        }
        this.featureRows[dataPointIndex].set(featureIndex, featureValue);
        this.featureColumns[featureIndex].set(dataPointIndex, featureValue);
    }

    @Override
    public boolean isDense() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializableVector[] serFeatureRows = new SerializableVector[this.featureRows.length];
        for (int i = 0; i < this.featureRows.length; ++i) {
            serFeatureRows[i] = new SerializableVector((Vector)this.featureRows[i]);
        }
        SerializableVector[] serFeatureColumns = new SerializableVector[this.featureColumns.length];
        for (int i = 0; i < this.featureColumns.length; ++i) {
            serFeatureColumns[i] = new SerializableVector((Vector)this.featureColumns[i]);
        }
        out.writeObject(serFeatureRows);
        out.writeObject(serFeatureColumns);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializableVector[] serFeatureRows = (SerializableVector[])in.readObject();
        this.featureRows = new DenseVector[serFeatureRows.length];
        for (int i = 0; i < this.featureRows.length; ++i) {
            this.featureRows[i] = (DenseVector)serFeatureRows[i].getVector();
        }
        SerializableVector[] serFeatureColumns = (SerializableVector[])in.readObject();
        this.featureColumns = new DenseVector[serFeatureColumns.length];
        for (int i = 0; i < this.featureColumns.length; ++i) {
            this.featureColumns[i] = (DenseVector)serFeatureColumns[i].getVector();
        }
    }
}

