/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.DenseDataSet;
import edu.neu.ccs.pyramid.dataset.Density;
import edu.neu.ccs.pyramid.dataset.SequentialSparseDataSet;
import edu.neu.ccs.pyramid.dataset.SparseDataSet;

public class DataSetBuilder {
    private int numDataPoints = -1;
    private int numFeatures = -1;
    private boolean dense = true;
    private boolean missingValue = false;
    private Density density = Density.DENSE;

    public static DataSetBuilder getBuilder() {
        return new DataSetBuilder();
    }

    public DataSetBuilder numDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
        return this;
    }

    public DataSetBuilder numFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
        return this;
    }

    public DataSetBuilder dense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public DataSetBuilder missingValue(boolean missingValue) {
        this.missingValue = missingValue;
        return this;
    }

    public DataSetBuilder density(Density density) {
        this.density = density;
        return this;
    }

    public DataSet build() {
        if (!this.valid()) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        AbstractDataSet dataSet = null;
        switch (this.density) {
            case DENSE: {
                dataSet = new DenseDataSet(this.numDataPoints, this.numFeatures, this.missingValue);
                break;
            }
            case SPARSE_RANDOM: {
                dataSet = new SparseDataSet(this.numDataPoints, this.numFeatures, this.missingValue);
                break;
            }
            case SPARSE_SEQUENTIAL: {
                dataSet = new SequentialSparseDataSet(this.numDataPoints, this.numFeatures, this.missingValue);
            }
        }
        return dataSet;
    }

    private boolean valid() {
        if (this.numDataPoints <= 0) {
            return false;
        }
        return this.numFeatures > 0;
    }
}

