/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.AbstractDataSet;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.DenseClfDataSet;
import edu.neu.ccs.pyramid.dataset.SparseClfDataSet;

public class ClfDataSetBuilder {
    private int numDataPoints = -1;
    private int numFeatures = -1;
    private boolean dense = true;
    private boolean missingValue = false;
    private int numClasses = -1;

    public static ClfDataSetBuilder getBuilder() {
        return new ClfDataSetBuilder();
    }

    public ClfDataSetBuilder numDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
        return this;
    }

    public ClfDataSetBuilder numFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
        return this;
    }

    public ClfDataSetBuilder dense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public ClfDataSetBuilder missingValue(boolean missingValue) {
        this.missingValue = missingValue;
        return this;
    }

    public ClfDataSetBuilder numClasses(int numClasses) {
        this.numClasses = numClasses;
        return this;
    }

    public ClfDataSet build() {
        if (!this.valid()) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        AbstractDataSet dataSet = this.dense ? new DenseClfDataSet(this.numDataPoints, this.numFeatures, this.missingValue, this.numClasses) : new SparseClfDataSet(this.numDataPoints, this.numFeatures, this.missingValue, this.numClasses);
        return dataSet;
    }

    private boolean valid() {
        if (this.numDataPoints <= 0) {
            System.out.println("numDataPoints<=0");
            return false;
        }
        if (this.numFeatures <= 0) {
            System.out.println("numFeatures<=0");
            return false;
        }
        if (this.numClasses <= 0) {
            System.out.println("numClasses<=0");
            return false;
        }
        return true;
    }
}

