/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.dataset;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.IdTranslator;
import edu.neu.ccs.pyramid.feature.Feature;
import edu.neu.ccs.pyramid.feature.FeatureList;
import org.apache.mahout.math.Vector;

abstract class AbstractDataSet
implements DataSet {
    protected int numDataPoints;
    protected int numFeatures;
    protected boolean missingValue;
    protected IdTranslator idTranslator;
    protected FeatureList featureList;

    AbstractDataSet(int numDataPoints, int numFeatures, boolean missingValue) {
        this.numDataPoints = numDataPoints;
        this.numFeatures = numFeatures;
        this.missingValue = missingValue;
        this.idTranslator = IdTranslator.newDefaultIdTranslator(numDataPoints);
        this.featureList = new FeatureList();
        for (int j = 0; j < numFeatures; ++j) {
            Feature feature = new Feature();
            this.featureList.add(feature);
        }
    }

    AbstractDataSet(int numDataPoints, int numFeatures, boolean missingValue, IdTranslator idTranslator) {
        this.numDataPoints = numDataPoints;
        this.numFeatures = numFeatures;
        this.missingValue = missingValue;
        this.idTranslator = idTranslator;
        this.featureList = new FeatureList();
        for (int j = 0; j < numFeatures; ++j) {
            Feature feature = new Feature();
            this.featureList.add(feature);
        }
    }

    @Override
    public int getNumDataPoints() {
        return this.numDataPoints;
    }

    @Override
    public int getNumFeatures() {
        return this.numFeatures;
    }

    @Override
    public abstract Vector getColumn(int var1);

    @Override
    public abstract Vector getRow(int var1);

    @Override
    public abstract void setFeatureValue(int var1, int var2, double var3);

    @Override
    public boolean hasMissingValue() {
        return this.missingValue;
    }

    protected void allowMissingValue() {
        this.missingValue = true;
    }

    @Override
    public IdTranslator getIdTranslator() {
        return this.idTranslator;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("number of data points = ").append(this.numDataPoints).append("\n");
        sb.append("number of features = ").append(this.numFeatures).append("\n");
        sb.append("has missing value = ").append(this.missingValue).append("\n");
        sb.append("row matrix:").append("\n");
        for (int i = 0; i < this.numDataPoints; ++i) {
            sb.append(i).append(":\t").append(this.getRow(i).asFormatString()).append("\n");
        }
        sb.append("=====================================").append("\n");
        sb.append("column matrix:").append("\n");
        for (int j = 0; j < this.numFeatures; ++j) {
            sb.append(j).append(":\t").append(this.getColumn(j).asFormatString()).append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String getMetaInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("data set meta information:").append("\n");
        sb.append("number of data points = ").append(this.getNumDataPoints()).append("\n");
        sb.append("number of features = ").append(this.getNumFeatures()).append("\n");
        sb.append("has missing value = ").append(this.missingValue).append("\n");
        return sb.toString();
    }

    @Override
    public void setIdTranslator(IdTranslator idTranslator) {
        this.idTranslator = idTranslator;
    }

    @Override
    public void setFeatureList(FeatureList featureList) {
        if (featureList.size() != this.numFeatures) {
            throw new IllegalArgumentException("featureList.size()!=this.numFeatures");
        }
        this.featureList = featureList;
    }
}

