/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.configuration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.neu.ccs.pyramid.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;

@JsonSerialize(using=Serializer.class)
public class Config {
    private Properties properties = new Properties();

    public Config(String configFile) {
        this(new File(configFile));
    }

    public Config(File configFile) {
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            this.properties.load(fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setString("pyramid.version", Version.getVersion());
    }

    public Config() {
        this.setString("pyramid.version", Version.getVersion());
    }

    public static Config newConfigFromString(String s) {
        Config config = new Config();
        config.properties = new Properties();
        try {
            config.properties.load(new StringReader(s));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public void setInt(String key, int value) {
        this.properties.setProperty(key, "" + value);
    }

    public void setDouble(String key, double value) {
        this.properties.setProperty(key, "" + value);
    }

    public void setBoolean(String key, boolean value) {
        this.properties.setProperty(key, "" + value);
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public int getInt(String key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("config does not contain the key " + key);
        }
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public List<String> getStrings(String key) {
        String[] valuesSplit;
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("config does not contain the key " + key);
        }
        ArrayList<String> list = new ArrayList<String>();
        String values = this.properties.getProperty(key);
        if (values.equals("")) {
            return list;
        }
        for (String valueString : valuesSplit = values.split(",")) {
            list.add(valueString.trim());
        }
        return list;
    }

    public List<Integer> getIntegers(String key) {
        List<String> strings = this.getStrings(key);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String valueString : strings) {
            list.add(Integer.parseInt(valueString.trim()));
        }
        return list;
    }

    public List<Double> getDoubles(String key) {
        List<String> strings = this.getStrings(key);
        ArrayList<Double> list = new ArrayList<Double>();
        for (String valueString : strings) {
            list.add(Double.parseDouble(valueString.trim()));
        }
        return list;
    }

    public double getDouble(String key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("config does not contain the key " + key);
        }
        return Double.parseDouble(this.properties.getProperty(key));
    }

    public boolean getBoolean(String key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("config does not contain the key " + key);
        }
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public String getString(String key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("config does not contain the key " + key);
        }
        return this.properties.getProperty(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public void store(Writer writer) throws Exception {
        this.properties.store(writer, "");
    }

    public void store(File file) throws Exception {
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            this.store(bufferedWriter);
        }
    }

    public void storeOrdered(File file) throws Exception {
        String s = this.toString();
        FileUtils.writeStringToFile((File)file, (String)s);
    }

    public static void copy(Config src, Config des, String key) {
        des.setString(key, src.getString(key));
    }

    public static void copy(Config src, Config des, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Config.copy(src, des, key);
        }
    }

    public static void copyExisting(Config src, Config des, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!src.containsKey(key)) continue;
            Config.copy(src, des, key);
        }
    }

    public static void copy(Config src, Config des) {
        for (String key : src.getKeys()) {
            Config.copy(src, des, key);
        }
    }

    public Set<String> getKeys() {
        return this.properties.stringPropertyNames();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.properties.stringPropertyNames()) {
            list.add(key);
        }
        Collections.sort(list);
        for (String key : list) {
            sb.append(key).append("=").append(this.properties.getProperty(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Serializer
    extends JsonSerializer<Config> {
        public void serialize(Config config, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : config.properties.stringPropertyNames()) {
                list.add(key);
            }
            Collections.sort(list);
            jsonGenerator.writeStartObject();
            for (String key : list) {
                jsonGenerator.writeStringField(key, config.getString(key));
            }
            jsonGenerator.writeEndObject();
        }
    }
}

