/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.classification.logistic_regression;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class Weights
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int numClasses;
    private int numFeatures;
    private transient Vector weightVector;

    public Weights(int numClasses, int numFeatures, boolean random) {
        if (random) {
            this.numClasses = numClasses;
            this.numFeatures = numFeatures;
            this.weightVector = new DenseVector((numFeatures + 1) * numClasses);
            Random randomGenerator = new Random(0L);
            for (int i = 0; i < this.weightVector.size(); ++i) {
                double p = randomGenerator.nextDouble() - 0.5;
                this.weightVector.set(i, p);
            }
        } else {
            this.numClasses = numClasses;
            this.numFeatures = numFeatures;
            this.weightVector = new DenseVector((numFeatures + 1) * numClasses);
        }
    }

    public Weights(int numClasses, int numFeatures) {
        this.numClasses = numClasses;
        this.numFeatures = numFeatures;
        this.weightVector = new DenseVector((numFeatures + 1) * numClasses);
    }

    public Weights(int numClasses, int numFeatures, Vector weightVector) {
        this.numClasses = numClasses;
        this.numFeatures = numFeatures;
        if (weightVector.size() != (numFeatures + 1) * numClasses) {
            throw new IllegalArgumentException("weightVector.size()!=(numFeatures + 1)*numClasses");
        }
        this.weightVector = weightVector;
    }

    public void setWeightVector(Vector weightVector) {
        if (weightVector.size() != (this.numFeatures + 1) * this.numClasses) {
            throw new IllegalArgumentException("weightVector.size()!=(numFeatures + 1)*numClasses");
        }
        this.weightVector = weightVector;
    }

    public Weights deepCopy() {
        Weights copy = new Weights(this.numClasses, this.numFeatures);
        copy.weightVector = new DenseVector(this.weightVector);
        return copy;
    }

    public int getClassIndex(int parameterIndex) {
        return parameterIndex / (this.numFeatures + 1);
    }

    public int getFeatureIndex(int parameterIndex) {
        return parameterIndex - this.getClassIndex(parameterIndex) * (this.numFeatures + 1) - 1;
    }

    public List<Integer> getAllBiasPositions() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int k = 0; k < this.numClasses; ++k) {
            list.add((this.numFeatures + 1) * k);
        }
        return list;
    }

    public Vector getAllWeights() {
        return this.weightVector;
    }

    public int totalSize() {
        return this.weightVector.size();
    }

    void truncateByThreshold(double threshold) {
        for (int k = 0; k < this.numClasses; ++k) {
            Vector vector = this.getWeightsWithoutBiasForClass(k);
            for (int d = 0; d < vector.size(); ++d) {
                if (!(Math.abs(vector.get(d)) < threshold)) continue;
                vector.set(d, 0.0);
            }
        }
    }

    public Vector getWeightsForClass(int k) {
        if (k >= this.numClasses) {
            throw new IllegalArgumentException("out of bound");
        }
        int start = (this.numFeatures + 1) * k;
        int length = this.numFeatures + 1;
        return new VectorView(this.weightVector, start, length);
    }

    public Vector getWeightsWithoutBiasForClass(int k) {
        if (k >= this.numClasses) {
            throw new IllegalArgumentException("out of bound");
        }
        int start = (this.numFeatures + 1) * k + 1;
        int length = this.numFeatures;
        return new VectorView(this.weightVector, start, length);
    }

    public double getBiasForClass(int k) {
        if (k >= this.numClasses) {
            throw new IllegalArgumentException("out of bound");
        }
        int start = (this.numFeatures + 1) * k;
        return this.weightVector.get(start);
    }

    public void setBiasForClass(double bias, int k) {
        if (k >= this.numClasses) {
            throw new IllegalArgumentException("out of bound");
        }
        int start = (this.numFeatures + 1) * k;
        this.weightVector.set(start, bias);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.numClasses);
        out.writeInt(this.numFeatures);
        int numNonZeros = this.weightVector.getNumNonZeroElements();
        int[] indices = new int[numNonZeros];
        double[] values = new double[numNonZeros];
        int i = 0;
        for (Vector.Element element : this.weightVector.nonZeroes()) {
            int index = element.index();
            double v = element.get();
            indices[i] = index;
            values[i] = v;
            ++i;
        }
        out.writeObject(indices);
        out.writeObject(values);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.numClasses = in.readInt();
        this.numFeatures = in.readInt();
        int[] indices = (int[])in.readObject();
        double[] values = (double[])in.readObject();
        this.weightVector = new DenseVector((this.numFeatures + 1) * this.numClasses);
        for (int i = 0; i < indices.length; ++i) {
            this.weightVector.set(indices[i], values[i]);
        }
    }

    void serialize(File file) throws Exception {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    /*
     * Exception decompiling
     */
    public static Weights deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Weights{");
        for (int k = 0; k < this.numClasses; ++k) {
            sb.append("for class ").append(k).append(":").append("\n");
            sb.append("bias = " + this.getBiasForClass(k)).append(",");
            sb.append("weights = " + this.getWeightsWithoutBiasForClass(k)).append("\n");
        }
        sb.append('}');
        return sb.toString();
    }
}

