/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.classification.logistic_regression;

import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticLoss;
import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticRegression;
import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.optimization.LBFGS;
import edu.neu.ccs.pyramid.optimization.Optimizable;
import edu.neu.ccs.pyramid.optimization.Optimizer;

public class RidgeLogisticOptimizer {
    private Optimizer optimizer;
    private Optimizable.ByGradientValue function;
    private boolean isParallel = false;

    public RidgeLogisticOptimizer(LogisticLoss logisticLoss) {
        this.function = logisticLoss;
        this.optimizer = new LBFGS(this.function);
        this.optimizer.getTerminator().setAbsoluteEpsilon(0.1);
    }

    public RidgeLogisticOptimizer(LogisticRegression logisticRegression, DataSet dataSet, int[] labels, double gaussianPriorVariance, boolean parallel) {
        this(logisticRegression, dataSet, RidgeLogisticOptimizer.labelsToDistributions(labels, logisticRegression.getNumClasses()), gaussianPriorVariance, parallel);
    }

    public RidgeLogisticOptimizer(LogisticRegression logisticRegression, DataSet dataSet, int[] labels, double[] weights, double gaussianPriorVariance, boolean parallel) {
        this(logisticRegression, dataSet, weights, RidgeLogisticOptimizer.labelsToDistributions(labels, logisticRegression.getNumClasses()), gaussianPriorVariance, parallel);
    }

    public RidgeLogisticOptimizer(LogisticRegression logisticRegression, DataSet dataSet, double[][] targetDistributions, double gaussianPriorVariance, boolean parallel) {
        this.function = new LogisticLoss(logisticRegression, dataSet, targetDistributions, gaussianPriorVariance, parallel);
        this.optimizer = new LBFGS(this.function);
        this.optimizer.getTerminator().setAbsoluteEpsilon(0.1);
    }

    public RidgeLogisticOptimizer(LogisticRegression logisticRegression, ClfDataSet dataSet, double gaussianPriorVariance, boolean parallel) {
        this.function = new LogisticLoss(logisticRegression, dataSet, gaussianPriorVariance, parallel);
        this.optimizer = new LBFGS(this.function);
        this.optimizer.getTerminator().setAbsoluteEpsilon(0.1);
    }

    public RidgeLogisticOptimizer(LogisticRegression logisticRegression, DataSet dataSet, double[] weights, double[][] targetsDistribution, double gaussianPriorVar, boolean parallel) {
        this.function = new LogisticLoss(logisticRegression, dataSet, weights, targetsDistribution, gaussianPriorVar, parallel);
        this.optimizer = new LBFGS(this.function);
        this.optimizer.getTerminator().setAbsoluteEpsilon(0.1);
    }

    public void optimize() {
        this.optimizer.optimize();
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Optimizable.ByGradientValue getFunction() {
        return this.function;
    }

    private static double[][] labelsToDistributions(int[] labels, int numClass) {
        int numData = labels.length;
        double[][] distribution = new double[numData][numClass];
        for (int i = 0; i < numData; ++i) {
            int label = labels[i];
            distribution[i][label] = 1.0;
        }
        return distribution;
    }
}

