/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.classification;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.feature.FeatureList;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Vector;

public class Voting
implements Classifier {
    private int numClasses;
    private List<Classifier> classifiers;
    private FeatureList featureList;
    private LabelTranslator labelTranslator;

    public Voting(int numClasses) {
        this.numClasses = numClasses;
        this.classifiers = new ArrayList<Classifier>();
    }

    public void add(Classifier classifier) {
        this.classifiers.add(classifier);
    }

    @Override
    public int predict(Vector vector) {
        int[] votes = new int[this.numClasses];
        for (Classifier classifier : this.classifiers) {
            int prediction;
            int n = prediction = classifier.predict(vector);
            votes[n] = votes[n] + 1;
        }
        int max = 0;
        int out = 0;
        for (int i = 0; i < this.numClasses; ++i) {
            if (votes[i] <= max) continue;
            max = votes[i];
            out = i;
        }
        return out;
    }

    @Override
    public int getNumClasses() {
        return this.numClasses;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }

    @Override
    public LabelTranslator getLabelTranslator() {
        return this.labelTranslator;
    }

    public void setLabelTranslator(LabelTranslator labelTranslator) {
        this.labelTranslator = labelTranslator;
    }
}

