/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.application;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import edu.neu.ccs.pyramid.configuration.Config;
import java.lang.reflect.Method;
import java.util.Arrays;

public class AppLauncher {
    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            AppLauncher.launch(args);
        } else {
            AppLauncher.error();
        }
    }

    private static void launch(String[] args) throws Exception {
        Config config = new Config(args[0]);
        String className = config.getString("pyramid.class");
        String[] mainArgs = Arrays.copyOfRange(args, 0, 1);
        String realName = AppLauncher.matchClass(className);
        if (realName == null) {
            System.err.println("Unknown app name: " + className);
            System.exit(1);
        }
        AppLauncher.invokeMain(realName, mainArgs);
    }

    private static void error() {
        System.err.println("Invalid command.\nUsage: ./pyramid <properties_file>\nThe <properties_file> can be specified by either an absolute or a relative path.\nExample: ./pyramid config/welcome.properties");
        System.exit(1);
    }

    private static String matchClass(String className) throws Exception {
        String lower = className.toLowerCase();
        String realName = null;
        ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
        ImmutableSet classes = classPath.getTopLevelClasses("edu.neu.ccs.pyramid.application");
        for (ClassPath.ClassInfo classInfo : classes) {
            if (!classInfo.getSimpleName().toLowerCase().equals(lower)) continue;
            realName = classInfo.getName();
            break;
        }
        return realName;
    }

    private static void invokeMain(String className, String[] args) throws Exception {
        Class<?> c = Class.forName(className);
        Class[] argTypes = new Class[]{String[].class};
        Method main = c.getDeclaredMethod("main", argTypes);
        main.invoke(null, new Object[]{args});
    }
}

