/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.CreateTableUsing;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u00015\u00111bQ1uC2|w-S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqaY1uC2|w-\u0003\u0002\u0014!\t91)\u0019;bY><\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)QC\u0007a\u0001-!)\u0011\u0005\u0001C\u0005E\u0005q1/Z:tS>t7)\u0019;bY><W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005E1#BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015&\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQa\u000b\u0001\u0005\n1\nQC]3rk&\u0014X\rR1uC\n\f7/Z#ySN$8\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00061\u00016\u0003\u0019!'MT1nKB\u0011a'\u000f\b\u0003]]J!\u0001O\u0018\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q=BQ!\u0010\u0001\u0005\ny\n!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019Qf\u0010!\t\u000bQb\u0004\u0019A\u001b\t\u000b\u0005c\u0004\u0019A\u001b\u0002\u0013Q\f'\r\\3OC6,\u0007\"B\"\u0001\t\u0003\"\u0015aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003UBQA\u0012\u0001\u0005B\u001d\u000b!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011Q\u0006\u0013\u0005\u0006i\u0015\u0003\r!\u000e\u0015\u0004\u000b*\u0003\u0006c\u0001\u0018L\u001b&\u0011Aj\f\u0002\u0007i\"\u0014xn^:\u0011\u0005]q\u0015BA(\u0005\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002#\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\u0006'\u0002!\t\u0005V\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003U\u00032a\u0006,Y\u0013\t9FAA\u0004ECR\f7/\u001a;\u0011\u0005=I\u0016B\u0001.\u0011\u0005!!\u0015\r^1cCN,\u0007\"\u0002/\u0001\t\u0003j\u0016A\u00037jgR$\u0016M\u00197fgR\ta\fE\u0002\u0018-~\u0003\"a\u00041\n\u0005\u0005\u0004\"!\u0002+bE2,\u0007\"\u0002/\u0001\t\u0003\u001aGC\u00010e\u0011\u0015!$\r1\u00016Q\r\u0011'\n\u0015\u0005\u0006O\u0002!\t\u0005[\u0001\u000eY&\u001cHOR;oGRLwN\\:\u0015\u0003%\u00042a\u0006,k!\ty1.\u0003\u0002m!\tAa)\u001e8di&|g\u000eC\u0003h\u0001\u0011\u0005c\u000e\u0006\u0002j_\")A'\u001ca\u0001k!\u001aQN\u0013)\t\u000bI\u0004A\u0011I:\u0002\u00171L7\u000f^\"pYVlgn\u001d\u000b\u0003ib\u00042a\u0006,v!\tya/\u0003\u0002x!\t11i\u001c7v[:DQ!Q9A\u0002UB3!\u001d&{C\u0005Y\u0018\u0001\u0006;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000fC\u0003s\u0001\u0011\u0005S\u0010F\u0002u}~DQ\u0001\u000e?A\u0002UBQ!\u0011?A\u0002UBC\u0001 &\u0002\u0004\u0005\u0012\u0011QA\u0001!I\u0006$\u0018MY1tK\u0002z'\u000f\t;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000f\u0003\u0004s\u0001\u0011%\u0011\u0011\u0002\u000b\u0004i\u0006-\u0001\u0002CA\u0007\u0003\u000f\u0001\r!a\u0004\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004B!!\u0005\u0002\u00145\ta%C\u0002\u0002\u0016\u0019\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\b\u00033\u0001A\u0011IA\u000e\u0003M\u0019'/Z1uK\u0016CH/\u001a:oC2$\u0016M\u00197f)\u0019\ti\"!\u0011\u0002DA!\u0011qDA\u001e\u001d\u0011\t\t#a\u000e\u000f\t\u0005\r\u0012Q\u0007\b\u0005\u0003K\t\u0019D\u0004\u0003\u0002(\u0005Eb\u0002BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055B\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005eB!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\u000f\u0005\u0011\u0019\t\u0015q\u0003a\u0001k!9\u0011QIA\f\u0001\u0004)\u0014\u0001\u00029bi\"DC!a\u0006\u0002JA!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019&!\u0014\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\t\u000f\u0005e\u0001\u0001\"\u0011\u0002XQA\u0011QDA-\u00037\ni\u0006\u0003\u0004B\u0003+\u0002\r!\u000e\u0005\b\u0003\u000b\n)\u00061\u00016\u0011\u001d\ty&!\u0016A\u0002U\naa]8ve\u000e,\u0007\u0006BA+\u0003\u0013Bq!!\u0007\u0001\t\u0003\n)\u0007\u0006\u0005\u0002\u001e\u0005\u001d\u0014\u0011NA6\u0011\u0019\t\u00151\ra\u0001k!9\u0011qLA2\u0001\u0004)\u0004\u0002CA7\u0003G\u0002\r!a\u001c\u0002\u000f=\u0004H/[8ogB1\u0011\u0011OA>kUj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0005kRLGN\u0003\u0002\u0002z\u0005!!.\u0019<b\u0013\u0011\ti(a\u001d\u0003\u00075\u000b\u0007\u000f\u000b\u0003\u0002d\u0005%\u0003bBA\r\u0001\u0011\u0005\u00131\u0011\u000b\t\u0003;\t))a\"\u0002\n\"1\u0011)!!A\u0002UBq!a\u0018\u0002\u0002\u0002\u0007Q\u0007\u0003\u0005\u0002n\u0005\u0005\u0005\u0019AAF!\u00151\u0014QR\u001b6\u0013\r\tih\u000f\u0015\u0005\u0003\u0003\u000bI\u0005C\u0004\u0002\u001a\u0001!\t%a%\u0015\u0015\u0005u\u0011QSAL\u00033\u000bI\u000b\u0003\u0004B\u0003#\u0003\r!\u000e\u0005\b\u0003?\n\t\n1\u00016\u0011!\tY*!%A\u0002\u0005u\u0015AB:dQ\u0016l\u0017\r\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019\u000bB\u0001\u0006if\u0004Xm]\u0005\u0005\u0003O\u000b\tK\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"!\u001c\u0002\u0012\u0002\u0007\u0011q\u000e\u0015\u0005\u0003#\u000bI\u0005C\u0004\u0002\u001a\u0001!\t%a,\u0015\u0015\u0005u\u0011\u0011WAZ\u0003k\u000b9\f\u0003\u0004B\u0003[\u0003\r!\u000e\u0005\b\u0003?\ni\u000b1\u00016\u0011!\tY*!,A\u0002\u0005u\u0005\u0002CA7\u0003[\u0003\r!a#)\t\u00055\u0016\u0011\n\u0005\b\u0003{\u0003A\u0011IA`\u00031!'o\u001c9UK6\u0004h+[3x)\ri\u0013\u0011\u0019\u0005\b\u0003\u0007\fY\f1\u00016\u0003!1\u0018.Z<OC6,\u0007bBAd\u0001\u0011\u0005\u0013\u0011Z\u0001\tSN\u001c\u0015m\u00195fIR!\u00111ZAi!\rq\u0013QZ\u0005\u0004\u0003\u001f|#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0006\u0015\u0007\u0019A\u001b\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\u0006Q1-Y2iKR\u000b'\r\\3\u0015\u00075\nI\u000e\u0003\u0004B\u0003'\u0004\r!\u000e\u0005\b\u0003;\u0004A\u0011IAp\u00031)hnY1dQ\u0016$\u0016M\u00197f)\ri\u0013\u0011\u001d\u0005\u0007\u0003\u0006m\u0007\u0019A\u001b\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\u00035B\u0001\"a2\u0001\t#!\u00111\u001e\u000b\u0005\u0003\u0017\fi\u000f\u0003\u0005\u0002p\u0006%\b\u0019AAy\u0003\u0015\th*Y7fa\u0011\t\u00190!?\u0011\t]1\u0016Q\u001f\t\u0005\u0003o\fI\u0010\u0004\u0001\u0005\u0019\u0005m\u0018Q^A\u0001\u0002\u0003\u0015\t!!@\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0000\n\u0015\u0001c\u0001\u0018\u0003\u0002%\u0019!1A\u0018\u0003\u000f9{G\u000f[5oOB\u0019aFa\u0002\n\u0007\t%qFA\u0002B]fDqA!\u0004\u0001\t\u0003\u0012y!\u0001\u0007sK\u001a\u0014Xm\u001d5UC\ndW\rF\u0002.\u0005#Aa!\u0011B\u0006\u0001\u0004)\u0004b\u0002B\u000b\u0001\u0011\u0005#qC\u0001\u000ee\u00164'/Z:i\u0005f\u0004\u0016\r\u001e5\u0015\u00075\u0012I\u0002C\u0004\u0003\u001c\tM\u0001\u0019A\u001b\u0002\u0019I,7o\\;sG\u0016\u0004\u0016\r\u001e5\b\u0011\t}!\u0001#\u0001\u0005\u0005C\t1bQ1uC2|w-S7qYB\u0019aDa\t\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0003&M!!1\u0005B\u0014!\rq#\u0011F\u0005\u0004\u0005Wy#AB!osJ+g\rC\u0004\u001c\u0005G!\tAa\f\u0015\u0005\t\u0005\u0002\u0002\u0003B\u001a\u0005G!\tA!\u000e\u0002\u00175\f7.\u001a#bi\u0006\u001cX\r^\u000b\u0005\u0005o\u0011y\u0004\u0006\u0004\u0003:\tu$Q\u0012\u000b\u0005\u0005w\u0011Y\u0005\u0005\u0003\u0018-\nu\u0002\u0003BA|\u0005\u007f!\u0001B!\u0011\u00032\t\u0007!1\t\u0002\u0002)F!\u0011q B#!\u0011\t\tBa\u0012\n\u0007\t%cE\u0001\u000eEK\u001aLg.\u001a3Cs\u000e{gn\u001d;sk\u000e$xN\u001d)be\u0006l7\u000f\u0003\u0006\u0003N\tE\u0012\u0011!a\u0002\u0005\u001f\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u0011\tF!\u001d\u0003>9!!1\u000bB6\u001d\u0011\u0011)Fa\u001a\u000f\t\t]#\u0011\r\b\u0005\u00053\u0012iF\u0004\u0003\u0002*\tm\u0013\"\u0001\u0019\n\u0007\t}s&A\u0004sK\u001adWm\u0019;\n\t\t\r$QM\u0001\beVtG/[7f\u0015\r\u0011yfL\u0005\u0005\u0003s\u0011IG\u0003\u0003\u0003d\t\u0015\u0014\u0002\u0002B7\u0005_\n\u0001\"\u001e8jm\u0016\u00148/\u001a\u0006\u0005\u0003s\u0011I'\u0003\u0003\u0003t\tU$a\u0002+za\u0016$\u0016mZ\u0005\u0005\u0005o\u0012IH\u0001\u0005UsB,G+Y4t\u0015\u0011\u0011YH!\u001a\u0002\u0007\u0005\u0004\u0018\u000e\u0003\u0005\u0003\u0000\tE\u0002\u0019\u0001BA\u0003\u0011!\u0017\r^1\u0011\r\t\r%q\u0011B\u001f\u001d\u0011\u0011IF!\"\n\u0007\u0005er&\u0003\u0003\u0003\n\n-%aA*fc*\u0019\u0011\u0011H\u0018\t\rU\u0011\t\u00041\u0001\u0017\u0001")
public class CatalogImpl
extends Catalog {
    public final SparkSession org$apache$spark$sql$internal$CatalogImpl$$sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    public SessionCatalog org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private void requireTableExists(String dbName, String tableName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' does not exist in database '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public String currentDatabase() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listDatabases().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Database apply(String dbName) {
                CatalogDatabase metadata = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getDatabaseMetadata(dbName);
                return new Database(metadata.name(), metadata.description(), metadata.locationUri());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.catalog.Database")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(this)));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq tables = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listTables(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Table apply(TableIdentifier tableIdent) {
                boolean isTemp = tableIdent.database().isEmpty();
                None$ metadata = isTemp ? None$.MODULE$ : new Some((Object)this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTableMetadata(tableIdent));
                return new Table(tableIdent.identifier(), (String)metadata.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(CatalogTable x$1) {
                        return x$1.identifier().database();
                    }
                }).orNull(Predef$.MODULE$.conforms()), (String)metadata.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(CatalogTable x$2) {
                        return x$2.comment();
                    }
                }).orNull(Predef$.MODULE$.conforms()), (String)metadata.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(CatalogTable x$3) {
                        return x$3.tableType().name();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "TEMPORARY";
                    }
                }), isTemp);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.catalog.Table")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(this)));
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listFunctions(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Function apply(Tuple2<FunctionIdentifier, String> x0$1) {
                Tuple2<FunctionIdentifier, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    FunctionIdentifier funcIdent = (FunctionIdentifier)tuple2._1();
                    ExpressionInfo metadata = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().lookupFunctionInfo(funcIdent);
                    Function function = new Function(funcIdent.identifier(), (String)funcIdent.database().orNull(Predef$.MODULE$.conforms()), null, metadata.getClassName(), funcIdent.database().isEmpty());
                    return function;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.catalog.Function")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(this)));
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        return this.listColumns(new TableIdentifier(tableName, (Option)None$.MODULE$));
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = tableMetadata.bucketColumnNames().toSet();
        Seq columns2 = (Seq)tableMetadata.schema().map((Function1)new Serializable(this, partitionColumnNames, bucketColumnNames){
            public static final long serialVersionUID = 0L;
            private final Set partitionColumnNames$1;
            private final Set bucketColumnNames$1;

            public final Column apply(CatalogColumn c) {
                return new Column(c.name(), (String)c.comment().orNull(Predef$.MODULE$.conforms()), c.dataType(), c.nullable(), this.partitionColumnNames$1.contains((Object)c.name()), this.bucketColumnNames$1.contains((Object)c.name()));
            }
            {
                this.partitionColumnNames$1 = partitionColumnNames$1;
                this.bucketColumnNames$1 = bucketColumnNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.catalog.Column")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(this)));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path) {
        String dataSourceName = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createExternalTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path, String source) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, Map<String, String> options) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, scala.collection.immutable.Map<String, String> options) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CreateTableUsing cmd = new CreateTableUsing(tableIdent, (Option<StructType>)None$.MODULE$, source, false, options, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<BucketSpec>)None$.MODULE$, false, false);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().executePlan((LogicalPlan)cmd).toRdd();
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableIdent);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, Map<String, String> options) {
        return this.createExternalTable(tableName, source, schema, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, scala.collection.immutable.Map<String, String> options) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CreateTableUsing cmd = new CreateTableUsing(tableIdent, (Option<StructType>)new Some((Object)schema), source, false, options, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<BucketSpec>)None$.MODULE$, false, false);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().executePlan((LogicalPlan)cmd).toRdd();
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableIdent);
    }

    @Override
    public void dropTempView(String viewName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().getTempView(viewName).foreach((Function1)new Serializable(this, viewName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;
            private final String viewName$1;

            public final void apply(LogicalPlan tempView) {
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(Dataset$.MODULE$.ofRows(this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, tempView), this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$2());
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropTempView(this.viewName$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.viewName$1 = viewName$1;
            }
        });
    }

    @Override
    public boolean isCached(String tableName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void uncacheTable(String tableName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$2());
    }

    @Override
    public void clearCache() {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().refreshTable(tableIdent);
        LogicalPlan logicalPlan = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().lookupRelation(tableIdent, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().lookupRelation$default$2());
        boolean isCached = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(logicalPlan).nonEmpty();
        if (isCached) {
            Dataset<Row> df = Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, logicalPlan);
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(df, true);
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(df, (Option<String>)new Some((Object)tableIdent.table()), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().invalidateCachedPath(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, resourcePath);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession = sparkSession;
    }
}

