/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$$anonfun$add$1$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]1\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011$!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\n%\u0013\t)3CA\u0002B]f\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0005\u0002\u0011%tG/\u001a:oC2L!a\u000b\u0015\u0003\u000f1{wmZ5oO\"AQ\u0006\u0001B\u0001B\u0003%a&\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00020a5\ta!\u0003\u00022\r\ta1\u000b]1sWN+7o]5p]\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0003qCRD\u0007CA\u001b9\u001d\t\u0011b'\u0003\u00028'\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t94\u0003\u0003\u0005=\u0001\t\r\t\u0015a\u0003>\u0003))g/\u001b3f]\u000e,G%\r\t\u0004}\u0005[R\"A \u000b\u0005\u0001\u001b\u0012a\u0002:fM2,7\r^\u0005\u0003\u0005~\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019K%\n\u0006\u0002H\u0011B\u0019\u0001\u0004A\u000e\t\u000bq\u001a\u00059A\u001f\t\u000b5\u001a\u0005\u0019\u0001\u0018\t\u000bM\u001a\u0005\u0019\u0001\u001b\t\u000f1\u0003!\u0019!C\u0001\u001b\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQV\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011am\u001d\u0006\u0003'*\ta\u0001[1e_>\u0004\u0018BA+Q\u0005\u0011\u0001\u0016\r\u001e5\t\r]\u0003\u0001\u0015!\u0003O\u00035iW\r^1eCR\f\u0007+\u0019;iA!9\u0011\f\u0001b\u0001\n#Q\u0016a\u00034jY\u0016l\u0015M\\1hKJ,\u0012a\u0017\t\u00039\u0012t!\u0001G/\b\u000by\u0013\u0001\u0012A0\u0002\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001e\u0004\"\u0001\u00071\u0007\u000b\u0005\u0011\u0001\u0012A1\u0014\u0005\u0001\f\u0002\"\u0002#a\t\u0003\u0019G#A0\u0007\u000f\u0015\u0004\u0007\u0013aI\u0001M\nYa)\u001b7f\u001b\u0006t\u0017mZ3s'\t!\u0017\u0003C\u0003iI\u001a\u0005\u0011.\u0001\u0003mSN$Hc\u00016qcB\u0019!c[7\n\u00051\u001c\"!B!se\u0006L\bCA(o\u0013\ty\u0007K\u0001\u0006GS2,7\u000b^1ukNDQaM4A\u00029CQA]4A\u0002M\faAZ5mi\u0016\u0014\bCA(u\u0013\t)\bK\u0001\u0006QCRDg)\u001b7uKJDQa\u001e3\u0007\u0002a\fa!\\6eSJ\u001cHCA=}!\t\u0011\"0\u0003\u0002|'\t!QK\\5u\u0011\u0015\u0019d\u000f1\u0001O\u0011\u0015qHM\"\u0001\u0000\u0003\u0019)\u00070[:ugR!\u0011\u0011AA\u0004!\r\u0011\u00121A\u0005\u0004\u0003\u000b\u0019\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006gu\u0004\rA\u0014\u0005\b\u0003\u0017!g\u0011AA\u0007\u0003\u0011y\u0007/\u001a8\u0015\t\u0005=\u0011Q\u0003\t\u0004\u001f\u0006E\u0011bAA\n!\n\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\t\rM\nI\u00011\u0001O\u0011\u001d\tI\u0002\u001aD\u0001\u00037\taa\u0019:fCR,G\u0003BA\u000f\u0003G\u00012aTA\u0010\u0013\r\t\t\u0003\u0015\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u00044\u0003/\u0001\rA\u0014\u0005\b\u0003O!g\u0011AA\u0015\u0003\u0019\u0011XM\\1nKR)\u00110a\u000b\u00020!9\u0011QFA\u0013\u0001\u0004q\u0015aB:sGB\u000bG\u000f\u001b\u0005\b\u0003c\t)\u00031\u0001O\u0003!!Wm\u001d;QCRD\u0007bBA\u001bI\u001a\u0005\u0011qG\u0001\u0007I\u0016dW\r^3\u0015\u0007e\fI\u0004\u0003\u00044\u0003g\u0001\rA\u0014\u0004\u0007\u0003{\u0001\u0007!a\u0010\u0003%\u0019KG.Z\"p]R,\u0007\u0010^'b]\u0006<WM]\n\u0006\u0003w\t\u0012\u0011\t\t\u0004\u0003\u0007\"W\"\u00011\t\u0013M\nYD!A!\u0002\u0013q\u0005bCA%\u0003w\u0011\t\u0011)A\u0005\u0003\u0017\n!\u0002[1e_>\u00048i\u001c8g!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)%\u0006!1m\u001c8g\u0013\u0011\t)&a\u0014\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d!\u00151\bC\u0001\u00033\"b!a\u0017\u0002^\u0005}\u0003\u0003BA\"\u0003wAaaMA,\u0001\u0004q\u0005\u0002CA%\u0003/\u0002\r!a\u0013\t\u0015\u0005\r\u00141\bb\u0001\n\u0013\t)'\u0001\u0002gGV\u0011\u0011q\r\t\u0004\u001f\u0006%\u0014bAA6!\nYa)\u001b7f\u0007>tG/\u001a=u\u0011%\ty'a\u000f!\u0002\u0013\t9'A\u0002gG\u0002Bq\u0001[A\u001e\t\u0003\n\u0019\bF\u0003k\u0003k\n9\b\u0003\u00044\u0003c\u0002\rA\u0014\u0005\u0007e\u0006E\u0004\u0019A:\t\u0011\u0005\u001d\u00121\bC!\u0003w\"R!_A?\u0003\u007fBq!!\f\u0002z\u0001\u0007a\nC\u0004\u00022\u0005e\u0004\u0019\u0001(\t\u000f]\fY\u0004\"\u0011\u0002\u0004R\u0019\u00110!\"\t\rM\n\t\t1\u0001O\u0011!\tY!a\u000f\u0005B\u0005%E\u0003BA\b\u0003\u0017CaaMAD\u0001\u0004q\u0005\u0002CA\r\u0003w!\t%a$\u0015\t\u0005u\u0011\u0011\u0013\u0005\u0007g\u00055\u0005\u0019\u0001(\t\u000fy\fY\u0004\"\u0011\u0002\u0016R!\u0011\u0011AAL\u0011\u0019\u0019\u00141\u0013a\u0001\u001d\"A\u0011QGA\u001e\t\u0003\nY\nF\u0002z\u0003;CaaMAM\u0001\u0004qeABAQA\u0002\t\u0019KA\tGS2,7+_:uK6l\u0015M\\1hKJ\u001cR!a(\u0012\u0003\u0003B\u0011bMAP\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0017\u0005%\u0013q\u0014B\u0001B\u0003%\u00111\n\u0005\b\t\u0006}E\u0011AAV)\u0019\ti+a,\u00022B!\u00111IAP\u0011\u0019\u0019\u0014\u0011\u0016a\u0001\u001d\"A\u0011\u0011JAU\u0001\u0004\tY\u0005C\u0005R\u0003?\u0013\r\u0011\"\u0003\u00026V\u0011\u0011q\u0017\t\u0004\u001f\u0006e\u0016bAA^!\nQa)\u001b7f'f\u001cH/Z7\t\u0013\u0005}\u0016q\u0014Q\u0001\n\u0005]\u0016a\u00014tA!9\u0001.a(\u0005B\u0005\rG#\u00026\u0002F\u0006\u001d\u0007BB\u001a\u0002B\u0002\u0007a\n\u0003\u0004s\u0003\u0003\u0004\ra\u001d\u0005\t\u0003O\ty\n\"\u0011\u0002LR)\u00110!4\u0002P\"9\u0011QFAe\u0001\u0004q\u0005bBA\u0019\u0003\u0013\u0004\rA\u0014\u0005\bo\u0006}E\u0011IAj)\rI\u0018Q\u001b\u0005\u0007g\u0005E\u0007\u0019\u0001(\t\u0011\u0005-\u0011q\u0014C!\u00033$B!a\u0004\u0002\\\"11'a6A\u00029C\u0001\"!\u0007\u0002 \u0012\u0005\u0013q\u001c\u000b\u0005\u0003;\t\t\u000f\u0003\u00044\u0003;\u0004\rA\u0014\u0005\b}\u0006}E\u0011IAs)\u0011\t\t!a:\t\rM\n\u0019\u000f1\u0001O\u0011!\t)$a(\u0005B\u0005-HcA=\u0002n\"11'!;A\u00029Cq!!=\u0001A\u0003%1,\u0001\u0007gS2,W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002v\u0002\u0011\r\u0011\"\u0003\u0002x\u0006\u0001\"-\u0019;dQ\u001aKG.Z:GS2$XM]\u000b\u0003\u0003s\u0014R!a?\u0003\u0004M4q!!@\u0002\u0000\u0002\tIP\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BA}\u0003E\u0011\u0017\r^2i\r&dWm\u001d$jYR,'\u000f\t\t\u0005\u0005\u000b\u0011y!\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\t5\u0011\u0001\u00026bm\u0006LAA!\u0005\u0003\b\t1qJ\u00196fGRD\u0011B!\u0006\u0001\u0005\u0004%IAa\u0006\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u0003\u001aA!!1\u0004B\u0010\u001b\t\u0011iBC\u0002\u0003\u0016!IAA!\t\u0003\u001e\t\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011!\u0011)\u0003\u0001Q\u0001\n\te\u0011aC:fe&\fG.\u001b>fe\u0002BqA!\u000b\u0001\t#\u0011Y#A\u0007cCR\u001c\u0007.\u00133U_B\u000bG\u000f\u001b\u000b\u0004\u001d\n5\u0002\u0002\u0003B\u0018\u0005O\u0001\rA!\r\u0002\u000f\t\fGo\u00195JIB\u0019!Ca\r\n\u0007\tU2C\u0001\u0003M_:<\u0007b\u0002B\u001d\u0001\u0011E!1H\u0001\u000ea\u0006$\b\u000eV8CCR\u001c\u0007.\u00133\u0015\t\tE\"Q\b\u0005\u0007g\t]\u0002\u0019\u0001(\t\u000f\t\u0005\u0003\u0001\"\u0005\u0003D\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t\tA!\u0012\t\rM\u0012y\u00041\u0001O\u0011\u001d\u0011I\u0005\u0001C\t\u0005\u0017\n\u0011b]3sS\u0006d\u0017N_3\u0015\u000be\u0014iE!\u0015\t\u000f\t=#q\ta\u00017\u0005AQ.\u001a;bI\u0006$\u0018\r\u0003\u0005\u0003T\t\u001d\u0003\u0019\u0001B+\u0003\ryW\u000f\u001e\t\u0005\u0005/\u0012i&\u0004\u0002\u0003Z)!!1\fB\u0006\u0003\tIw.\u0003\u0003\u0003`\te#\u0001D(viB,Ho\u0015;sK\u0006l\u0007b\u0002B2\u0001\u0011E!QM\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002\u001c\u0005OB\u0001B!\u001b\u0003b\u0001\u0007!1N\u0001\u0003S:\u0004BAa\u0016\u0003n%!!q\u000eB-\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\tM\u0004\u0001\"\u0011\u0003v\u0005\u0019\u0011\r\u001a3\u0015\r\u0005\u0005!q\u000fB=\u0011!\u0011yC!\u001dA\u0002\tE\u0002b\u0002B(\u0005c\u0002\ra\u0007\u0005\b\u0005{\u0002A\u0011\u0002B@\u0003)9(/\u001b;f\u0005\u0006$8\r\u001b\u000b\bs\n\u0005%1\u0011BC\u0011!\u0011yCa\u001fA\u0002\tE\u0002b\u0002B(\u0005w\u0002\ra\u0007\u0005\t\u0005\u000f\u0013Y\b1\u0001\u0003\n\u00061qO]5uKJ\u0004rA\u0005BF7\tU\u00130C\u0002\u0003\u000eN\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\u0006a\u0012n\u001d$jY\u0016\fEN]3bIf,\u00050[:ug\u0016C8-\u001a9uS>tG\u0003BA\u0001\u0005+C\u0001Ba&\u0003\u0010\u0002\u0007!\u0011T\u0001\u0002KB!!q\u000bBN\u0013\u0011\u0011iJ!\u0017\u0003\u0017%{U\t_2faRLwN\u001c\u0005\b\u0005C\u0003A\u0011\tBR\u0003\r9W\r\u001e\u000b\u0005\u0005K\u0013Y\u000b\u0005\u0003\u0013\u0005O[\u0012b\u0001BU'\t1q\n\u001d;j_:D\u0001Ba\f\u0003 \u0002\u0007!\u0011\u0007\u0005\b\u0005C\u0003A\u0011\tBX)\u0019\u0011\tL!/\u0003@B!!c\u001bBZ!\u0019\u0011\"Q\u0017B\u00197%\u0019!qW\n\u0003\rQ+\b\u000f\\33\u0011!\u0011YL!,A\u0002\tu\u0016aB:uCJ$\u0018\n\u001a\t\u0006%\t\u001d&\u0011\u0007\u0005\t\u0005\u0003\u0014i\u000b1\u0001\u0003>\u0006)QM\u001c3JI\"9!Q\u0019\u0001\u0005B\t\u001d\u0017!C4fi2\u000bG/Z:u)\t\u0011I\rE\u0003\u0013\u0005O\u0013\u0019\fC\u0004\u0003N\u0002!\tEa4\u0002\u000bA,(oZ3\u0015\u0007e\u0014\t\u000e\u0003\u0005\u0003T\n-\u0007\u0019\u0001B\u0019\u0003A!\bN]3tQ>dGMQ1uG\"LE\rC\u0004\u0003X\u0002!IA!7\u0002#\r\u0014X-\u0019;f\r&dW-T1oC\u001e,'\u000fF\u0001\\\u0001")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final ClassTag<T> evidence$1;
    private final Path metadataPath;
    private final FileManager fileManager;
    private final PathFilter batchFilesFilter;
    private final SerializerInstance serializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    private PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    private SerializerInstance serializer() {
        return this.serializer;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        SerializationStream outStream = this.serializer().serializeStream(out);
        outStream.writeObject(metadata, this.evidence$1);
    }

    public T deserialize(InputStream in) {
        DeserializationStream inStream = this.serializer().deserializeStream(in);
        return (T)inStream.readObject(this.evidence$1);
    }

    @Override
    public boolean add(long batchId, T metadata) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            public final long batchId$1;
            public final Object metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Thread thread = Thread.currentThread();
                if (thread instanceof UninterruptibleThread) {
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$add$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.$outer.batchId$1, this.$outer.metadata$1, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$add$1$$anonfun$apply$mcZ$sp$1 $outer;

                                public final void apply(T metadata, OutputStream out) {
                                    this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().serialize(metadata, out);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$add$1 org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return true;
                }
                throw new IllegalStateException("HDFSMetadataLog.add() must be executed on a o.a.spark.util.UninterruptibleThread");
            }

            public /* synthetic */ HDFSMetadataLog org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.metadata$1 = var4_3;
            }
        }));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(long batchId, T metadata, Function2<T, OutputStream, BoxedUnit> writer) {
        int nextId = 0;
        Path tempPath = new Path(this.metadataPath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString()})));
        {
            FSDataOutputStream output2 = this.fileManager().create(tempPath);
            try {
                writer.apply(metadata, (Object)output2);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output2);
            }
            {
                this.logDebug((Function0<String>)new Serializable(this, batchId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final long batchId$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to write log #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchIdToPath(this.batchId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batchId$2 = batchId$2;
                    }
                });
                this.fileManager().rename(tempPath, this.batchIdToPath(batchId));
                this.fileManager().delete(tempPath);
                return;
            }
        }
    }

    private boolean isFileAlreadyExistsException(IOException e) {
        return e instanceof FileAlreadyExistsException || e.getMessage() != null && e.getMessage().startsWith("File already exists: ");
    }

    @Override
    public Option<T> get(long batchId) {
        Some some;
        FSDataInputStream input;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.fileManager().exists(batchMetadataFile)) {
            input = this.fileManager().open(batchMetadataFile);
            some = new Some(this.deserialize((InputStream)input));
        } else {
            this.logDebug((Function0<String>)new Serializable(this, batchMetadataFile){
                public static final long serialVersionUID = 0L;
                private final Path batchMetadataFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadataFile$1}));
                }
                {
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                }
            });
            some = None$.MODULE$;
        }
        return some;
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(batchIds).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;

                    public final long apply(FileStatus f) {
                        return this.$outer.pathToBatchId(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted((Ordering)Ordering.Long$.MODULE$)).reverse();
                Predef$.MODULE$.longArrayOps(batchIds).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long batchId) {
                        this.apply$mcVJ$sp(batchId);
                    }

                    public void apply$mcVJ$sp(long batchId) {
                        Option<T> batch = this.$outer.get(batchId);
                        if (batch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private FileManager createFileManager() {
        FileManager fileManager;
        Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConf();
        try {
            fileManager = new FileContextManager(this.metadataPath(), hadoopConf);
        }
        catch (UnsupportedFileSystemException unsupportedFileSystemException) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not use FileContext API for managing metadata log files at path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Using FileSystem API instead for managing log files. The log may be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.metadataPath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent under failures."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            fileManager = new FileSystemManager(this.metadataPath(), hadoopConf);
        }
        return fileManager;
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.evidence$1 = evidence$1;
        Logging.class.$init$((Logging)this);
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = this.createFileManager();
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new $anon$1(this);
        this.serializer = new JavaSerializer(sparkSession.sparkContext().conf()).newInstance();
    }

    public static interface FileManager {
        public FileStatus[] list(Path var1, PathFilter var2);

        public void mkdirs(Path var1);

        public boolean exists(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataOutputStream create(Path var1);

        public void rename(Path var1, Path var2);

        public void delete(Path var1);
    }

    public static class FileSystemManager
    implements FileManager {
        private final FileSystem fs;

        private FileSystem fs() {
            return this.fs;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fs().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            if (this.fs().exists(srcPath)) {
                if (this.fs().exists(destPath)) {
                    throw new FileAlreadyExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination path already exists: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destPath})));
                }
                if (this.fs().rename(srcPath, destPath)) {
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, destPath})));
            }
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath})));
        }

        @Override
        public void mkdirs(Path path) {
            this.fs().mkdirs(path, FsPermission.getDirDefault());
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fs().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fs().create(path, false);
        }

        @Override
        public boolean exists(Path path) {
            return this.fs().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fs().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        public FileSystemManager(Path path, Configuration hadoopConf) {
            this.fs = path.getFileSystem(hadoopConf);
        }
    }

    public static class FileContextManager
    implements FileManager {
        private final FileContext fc;

        private FileContext fc() {
            return this.fc;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fc().util().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            this.fc().rename(srcPath, destPath, new Options.Rename[0]);
        }

        @Override
        public void mkdirs(Path path) {
            this.fc().mkdir(path, FsPermission.getDirDefault(), true);
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fc().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fc().create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        }

        @Override
        public boolean exists(Path path) {
            return this.fc().util().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fc().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        public FileContextManager(Path path, Configuration hadoopConf) {
            this.fc = path.toUri().getScheme() == null ? FileContext.getFileContext((Configuration)hadoopConf) : FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
        }
    }
}

